/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.flink.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.useragent.AnalyzerUtilities;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;

public class AnalyzeUseragentFunction
extends ScalarFunction {
    private transient UserAgentAnalyzer userAgentAnalyzer;
    private final int cacheSize;
    private final List<String> extractedFields;
    private final List<String> allAllowedHeaders;

    public AnalyzeUseragentFunction(String ... desiredFields) {
        this(10000, Arrays.asList(desiredFields));
    }

    public AnalyzeUseragentFunction(List<String> desiredFields) {
        this(10000, desiredFields);
    }

    public AnalyzeUseragentFunction(int cacheSize, String ... desiredFields) {
        this(cacheSize, Arrays.asList(desiredFields));
    }

    public AnalyzeUseragentFunction(int cacheSize, List<String> desiredFields) {
        this.cacheSize = cacheSize;
        this.extractedFields = new ArrayList<String>(desiredFields);
        this.allAllowedHeaders = new ArrayList<String>();
    }

    public void open(FunctionContext context) {
        this.userAgentAnalyzer = (UserAgentAnalyzer)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().withFields(this.extractedFields)).withCache(this.cacheSize)).immediateInitialization()).build();
        if (this.extractedFields.isEmpty()) {
            this.extractedFields.addAll(this.userAgentAnalyzer.getAllPossibleFieldNamesSorted());
        }
        this.allAllowedHeaders.add("User-Agent");
        this.allAllowedHeaders.addAll(this.userAgentAnalyzer.supportedClientHintHeaders());
    }

    public Map<String, String> eval(String userAgentString) {
        return this.userAgentAnalyzer.parse(userAgentString).toMap(this.extractedFields);
    }

    public Map<String, String> eval(String ... input) {
        if (input == null || input.length == 0) {
            throw new IllegalArgumentException("Input may not be null or empty.");
        }
        AnalyzerUtilities.ParsedArguments parsedArguments = AnalyzerUtilities.parseArguments((String[])input, Collections.emptyList(), this.allAllowedHeaders);
        return this.userAgentAnalyzer.parse(parsedArguments.getRequestHeaders()).toMap(this.extractedFields);
    }
}

