/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.hive;

import java.util.ArrayList;
import java.util.List;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="ParseUserAgent", value="_FUNC_(str) - Parses the UserAgent into all possible pieces.", extended="Example:\n> SELECT ParseUserAgent(useragent).DeviceClass, \n         ParseUserAgent(useragent).OperatingsystemNameVersion, \n         ParseUserAgent(useragent).AgentNameVersionMajor \n  FROM   clickLogs;\n+---------------+-----------------------------+------------------------+\n|  deviceclass  | operatingsystemnameversion  | agentnameversionmajor  |\n+---------------+-----------------------------+------------------------+\n| Phone         | Android 6.0                 | Chrome 46              |\n| Tablet        | Android 5.1                 | Chrome 40              |\n| Desktop       | Linux Intel x86_64          | Chrome 59              |\n| Game Console  | Windows 10.0                | Edge 13                |\n+---------------+-----------------------------+------------------------+\n")
public class ParseUserAgent
extends GenericUDF {
    private StringObjectInspector useragentOI = null;
    private static UserAgentAnalyzer userAgentAnalyzer = null;
    private static List<String> fieldNames = null;

    private static synchronized void constructAnalyzer() {
        if (userAgentAnalyzer == null) {
            userAgentAnalyzer = (UserAgentAnalyzer)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).delayInitialization()).build();
            fieldNames = userAgentAnalyzer.getAllPossibleFieldNamesSorted();
        }
    }

    public ObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length != 1) {
            throw new UDFArgumentException("The argument list must be exactly 1 element");
        }
        ObjectInspector inputOI = args[0];
        if (!(inputOI instanceof StringObjectInspector)) {
            throw new UDFArgumentException("The argument must be a string");
        }
        this.useragentOI = (StringObjectInspector)inputOI;
        ParseUserAgent.constructAnalyzer();
        ArrayList<WritableStringObjectInspector> fieldObjectInspectors = new ArrayList<WritableStringObjectInspector>(fieldNames.size());
        for (String ignored : fieldNames) {
            fieldObjectInspectors.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldObjectInspectors);
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        String userAgentString = this.useragentOI.getPrimitiveJavaObject(args[0].get());
        if (userAgentString == null) {
            return null;
        }
        UserAgent userAgent = userAgentAnalyzer.parse(userAgentString);
        ArrayList<Text> result = new ArrayList<Text>(fieldNames.size());
        for (String fieldName : fieldNames) {
            String value = userAgent.getValue(fieldName);
            if (value == null) {
                result.add(null);
                continue;
            }
            result.add(new Text(value));
        }
        return result.toArray();
    }

    public String getDisplayString(String[] args) {
        return "Parses the UserAgent into all possible pieces.";
    }
}

