/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.dissector;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentDissector
extends Dissector {
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentDissector.class);
    private transient UserAgentAnalyzer.UserAgentAnalyzerBuilder userAgentAnalyzerBuilder;
    private static UserAgentAnalyzer userAgentAnalyzer = null;
    private static final String INPUT_TYPE = "HTTP.USERAGENT";
    private List<String> extraResources = new ArrayList<String>();
    private List<String> allPossibleFieldNames = new ArrayList<String>();
    private List<String> requestedFieldNames = new ArrayList<String>();
    private final Map<String, String> fieldNameMappingCache = new HashMap<String, String>(64);
    private final Map<String, String> dissectionNameMappingCache = new HashMap<String, String>(64);

    public String getInputType() {
        return INPUT_TYPE;
    }

    private UserAgentAnalyzer.UserAgentAnalyzerBuilder getUserAgentAnalyzerBuilder() {
        if (this.userAgentAnalyzerBuilder == null) {
            this.userAgentAnalyzerBuilder = (UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().delayInitialization()).dropTests()).hideMatcherLoadStats();
        }
        return this.userAgentAnalyzerBuilder;
    }

    public boolean initializeFromSettingsParameter(String rawParameter) {
        String[] parameters;
        String trimmedRawParameter = rawParameter.trim();
        if (trimmedRawParameter.isEmpty()) {
            return true;
        }
        for (String parameter : parameters = trimmedRawParameter.split("\\|")) {
            String trimmedParameter = parameter.trim();
            if (trimmedParameter.isEmpty()) continue;
            this.extraResources.add(trimmedParameter);
        }
        return true;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField agentField = parsable.getParsableField(INPUT_TYPE, inputname);
        String userAgentString = agentField.getValue().getString();
        if (userAgentString == null) {
            return;
        }
        UserAgent agent = userAgentAnalyzer.parse(userAgentString);
        for (String fieldName : this.requestedFieldNames) {
            parsable.addDissection(inputname, this.getFieldOutputType(fieldName), this.fieldNameToDissectionName(fieldName), agent.getValue(fieldName));
        }
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        UserAgentAnalyzer.UserAgentAnalyzerBuilder builder = UserAgentAnalyzer.newBuilder();
        this.extraResources.forEach(arg_0 -> ((UserAgentAnalyzer.UserAgentAnalyzerBuilder)builder).addResources(arg_0));
        this.allPossibleFieldNames = ((UserAgentAnalyzer)builder.build()).getAllPossibleFieldNamesSorted();
        for (String fieldName : this.allPossibleFieldNames) {
            this.ensureMappingsExistForFieldName(fieldName);
            result.add(this.getFieldOutputType(fieldName) + ":" + this.fieldNameToDissectionName(fieldName));
        }
        return result;
    }

    private String getFieldOutputType(String fieldName) {
        switch (fieldName) {
            case "AgentInformationUrl": {
                return "HTTP.URI";
            }
        }
        return "STRING";
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        String name = this.extractFieldName(inputname, outputname);
        String fieldName = this.dissectionNameToFieldName(name);
        if (fieldName == null) {
            LOG.error("There is NO fieldname for the requested \"{}\" ({})", (Object)outputname, (Object)name);
            return Casts.NO_CASTS;
        }
        this.requestedFieldNames.add(fieldName);
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() {
        LOG.info("Preparing UserAgentAnalyzer to extract {}", this.requestedFieldNames.isEmpty() ? "all fields" : this.requestedFieldNames);
        UserAgentAnalyzer.UserAgentAnalyzerBuilder builder = this.getUserAgentAnalyzerBuilder();
        this.extraResources.forEach(r -> LOG.warn("Loading extra resource: {}", r));
        this.extraResources.forEach(arg_0 -> ((UserAgentAnalyzer.UserAgentAnalyzerBuilder)builder).addResources(arg_0));
        this.requestedFieldNames.forEach(arg_0 -> ((UserAgentAnalyzer.UserAgentAnalyzerBuilder)builder).withField(arg_0));
        this.setupUserAgentAnalyzer();
    }

    private synchronized void setupUserAgentAnalyzer() {
        userAgentAnalyzer = (UserAgentAnalyzer)this.getUserAgentAnalyzerBuilder().build();
        userAgentAnalyzer.initializeMatchers();
    }

    protected void initializeNewInstance(Dissector newInstance) throws InvalidDissectorException {
        if (!(newInstance instanceof UserAgentDissector)) {
            String className = "<<<null>>>";
            if (newInstance != null) {
                className = newInstance.getClass().getCanonicalName();
            }
            throw new InvalidDissectorException("The provided instance of the dissector is a " + className + " which is not a UserAgentDissector");
        }
        UserAgentDissector newUserAgentDissector = (UserAgentDissector)newInstance;
        newUserAgentDissector.extraResources = new ArrayList<String>(this.extraResources);
        newUserAgentDissector.allPossibleFieldNames = new ArrayList<String>(this.allPossibleFieldNames);
        newUserAgentDissector.requestedFieldNames = new ArrayList<String>(this.requestedFieldNames);
        this.allPossibleFieldNames.forEach(newUserAgentDissector::ensureMappingsExistForFieldName);
    }

    void ensureMappingsExistForFieldName(String fieldName) {
        if (this.fieldNameMappingCache.containsKey(fieldName)) {
            return;
        }
        String dissectionName = fieldName.replaceAll("([A-Z])", "_$1").toLowerCase(Locale.ENGLISH).replaceFirst("_", "");
        this.fieldNameMappingCache.put(fieldName, dissectionName);
        this.dissectionNameMappingCache.put(dissectionName, fieldName);
    }

    String fieldNameToDissectionName(String fieldName) {
        return this.fieldNameMappingCache.get(fieldName);
    }

    String dissectionNameToFieldName(String dissectionName) {
        return this.dissectionNameMappingCache.get(dissectionName);
    }
}

