/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.trino;

import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.util.Map;
import java.util.TreeMap;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;

public final class ParseUserAgentFunctionClientHints {
    private static ThreadLocal<UserAgentAnalyzer> threadLocalUserAgentAnalyzer = ThreadLocal.withInitial(() -> (UserAgentAnalyzer)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).withCache(10000)).immediateInitialization()).build());

    private ParseUserAgentFunctionClientHints() {
    }

    private static Slice getSlice(Block elements, int i) {
        return elements.getSlice(i, 0, elements.getSliceLength(i));
    }

    @ScalarFunction(value="parse_user_agent")
    @Description(value="Tries to parse and analyze the provided useragent string and extract as many attributes as possible. Uses Yauaa (Yet Another UserAgent Analyzer) version 7.21.0. See https://yauaa.basjes.nl/udf/trino/ for documentation.")
    @SqlType(value="map(varchar, varchar)")
    public static Block parseUserAgent(@SqlType(value="array(varchar)") Block input) throws IllegalArgumentException {
        UserAgentAnalyzer userAgentAnalyzer = threadLocalUserAgentAnalyzer.get();
        TreeMap<String, String> requestHeaders = new TreeMap<String, String>();
        int i = 0;
        int inputLength = input.getPositionCount();
        while (i < inputLength) {
            Slice parameterSlice = ParseUserAgentFunctionClientHints.getSlice(input, i);
            if (parameterSlice == null) {
                throw new IllegalArgumentException("Null argument provided to ParseUserAgent.");
            }
            String parameter = parameterSlice.toStringUtf8();
            if (parameter.isEmpty()) {
                throw new IllegalArgumentException("Empty argument provided to ParseUserAgent.");
            }
            if (userAgentAnalyzer.supportedClientHintHeaders().stream().anyMatch(parameter::equalsIgnoreCase) || "User-Agent".equalsIgnoreCase(parameter)) {
                if (i + 1 >= inputLength) {
                    throw new IllegalArgumentException("Invalid last element in argument list (was a header name which requires a value to follow)");
                }
                String value = ParseUserAgentFunctionClientHints.getSlice(input, i + 1).toStringUtf8();
                ++i;
                requestHeaders.put(parameter, value);
                ++i;
                continue;
            }
            if (i == 0) {
                requestHeaders.put("User-Agent", ParseUserAgentFunctionClientHints.getSlice(input, i).toStringUtf8());
                ++i;
                continue;
            }
            throw new IllegalArgumentException("Bad argument list for ParseUserAgent: \"" + parameter + "\"");
        }
        UserAgent.ImmutableUserAgent userAgent = userAgentAnalyzer.parse(requestHeaders);
        Map resultMap = userAgent.toMap(userAgentAnalyzer.getAllPossibleFieldNamesSorted());
        MapType mapType = new MapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, new TypeOperators());
        MapBlockBuilder blockBuilder = mapType.createBlockBuilder(null, resultMap.size());
        blockBuilder.buildEntry((keyBuilder, valueBuilder) -> resultMap.forEach((key, value) -> {
            VarcharType.VARCHAR.writeString(keyBuilder, key);
            VarcharType.VARCHAR.writeString(valueBuilder, value);
        }));
        return mapType.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }
}

