/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.trino;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedMapValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Map;
import java.util.TreeMap;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;

public final class ParseUserAgentFunctionClientHints {
    private final BufferedMapValueBuilder mapValueBuilder;
    private static ThreadLocal<UserAgentAnalyzer> threadLocalUserAgentAnalyzer = ThreadLocal.withInitial(() -> (UserAgentAnalyzer)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).withCache(10000)).immediateInitialization()).build());

    public ParseUserAgentFunctionClientHints(@TypeParameter(value="map(varchar,varchar)") Type mapType) {
        this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
    }

    private static Slice getSlice(Block elements, int i) {
        return ((VariableWidthBlock)elements.getUnderlyingValueBlock()).getSlice(i);
    }

    @ScalarFunction(value="parse_user_agent")
    @Description(value="Tries to parse and analyze the provided useragent string and extract as many attributes as possible. Uses Yauaa (Yet Another UserAgent Analyzer) version 7.26.0. See https://yauaa.basjes.nl/udf/trino/ for documentation.")
    @SqlType(value="map(varchar, varchar)")
    public SqlMap parseUserAgent(@SqlType(value="array(varchar)") Block input) throws IllegalArgumentException {
        UserAgentAnalyzer userAgentAnalyzer = threadLocalUserAgentAnalyzer.get();
        TreeMap<String, String> requestHeaders = new TreeMap<String, String>();
        int i = 0;
        int inputLength = input.getPositionCount();
        while (i < inputLength) {
            Slice parameterSlice = ParseUserAgentFunctionClientHints.getSlice(input, i);
            if (parameterSlice == null) {
                throw new IllegalArgumentException("Null argument provided to ParseUserAgent.");
            }
            String parameter = parameterSlice.toStringUtf8();
            if (parameter.isEmpty()) {
                throw new IllegalArgumentException("Empty argument provided to ParseUserAgent.");
            }
            if (userAgentAnalyzer.supportedClientHintHeaders().stream().anyMatch(parameter::equalsIgnoreCase) || "User-Agent".equalsIgnoreCase(parameter)) {
                if (i + 1 >= inputLength) {
                    throw new IllegalArgumentException("Invalid last element in argument list (was a header name which requires a value to follow)");
                }
                String value = ParseUserAgentFunctionClientHints.getSlice(input, i + 1).toStringUtf8();
                ++i;
                requestHeaders.put(parameter, value);
                ++i;
                continue;
            }
            if (i == 0) {
                requestHeaders.put("User-Agent", ParseUserAgentFunctionClientHints.getSlice(input, i).toStringUtf8());
                ++i;
                continue;
            }
            throw new IllegalArgumentException("Bad argument list for ParseUserAgent: \"" + parameter + "\"");
        }
        UserAgent.ImmutableUserAgent userAgent = userAgentAnalyzer.parse(requestHeaders);
        Map resultMap = userAgent.toMap(userAgentAnalyzer.getAllPossibleFieldNamesSorted());
        return this.mapValueBuilder.build(resultMap.size(), (keyBuilder, valueBuilder) -> resultMap.forEach((key, value) -> {
            VarcharType.VARCHAR.writeSlice(keyBuilder, Slices.utf8Slice((String)key));
            VarcharType.VARCHAR.writeSlice(valueBuilder, Slices.utf8Slice((String)value));
        }));
    }
}

