/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.trino;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.BufferedMapValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Map;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;

public final class ParseUserAgentFunction {
    private final BufferedMapValueBuilder mapValueBuilder;
    private static ThreadLocal<UserAgentAnalyzer> threadLocalUserAgentAnalyzer = ThreadLocal.withInitial(() -> (UserAgentAnalyzer)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).withCache(10000)).immediateInitialization()).build());

    public ParseUserAgentFunction(@TypeParameter(value="map(varchar,varchar)") Type mapType) {
        this.mapValueBuilder = BufferedMapValueBuilder.createBuffered((MapType)((MapType)mapType));
    }

    @ScalarFunction(value="parse_user_agent")
    @Description(value="Tries to parse and analyze the provided useragent string and extract as many attributes as possible. Uses Yauaa (Yet Another UserAgent Analyzer) version 7.28.1. See https://yauaa.basjes.nl/udf/trino/ for documentation.")
    @SqlType(value="map(varchar, varchar)")
    public SqlMap parseUserAgent(@SqlType(value="varchar") Slice userAgentSlice) throws IllegalArgumentException {
        String userAgentStringToParse = null;
        if (userAgentSlice != null) {
            userAgentStringToParse = userAgentSlice.toStringUtf8();
        }
        UserAgentAnalyzer userAgentAnalyzer = threadLocalUserAgentAnalyzer.get();
        UserAgent.ImmutableUserAgent userAgent = userAgentAnalyzer.parse(userAgentStringToParse);
        Map resultMap = userAgent.toMap(userAgentAnalyzer.getAllPossibleFieldNamesSorted());
        return this.mapValueBuilder.build(resultMap.size(), (keyBuilder, valueBuilder) -> resultMap.forEach((key, value) -> {
            VarcharType.VARCHAR.writeSlice(keyBuilder, Slices.utf8Slice((String)key));
            VarcharType.VARCHAR.writeSlice(valueBuilder, Slices.utf8Slice((String)value));
        }));
    }
}

