/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.trino;

import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.util.Map;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;

public final class ParseUserAgentFunction {
    private static ThreadLocal<UserAgentAnalyzer> threadLocalUserAgentAnalyzer = ThreadLocal.withInitial(() -> (UserAgentAnalyzer)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).withCache(10000)).immediateInitialization()).build());

    private ParseUserAgentFunction() {
    }

    @ScalarFunction(value="parse_user_agent")
    @Description(value="Tries to parse and analyze the provided useragent string and extract as many attributes as possible. Uses Yauaa (Yet Another UserAgent Analyzer) version 7.9.1. See https://yauaa.basjes.nl/udf/trino/ for documentation.")
    @SqlType(value="map(varchar, varchar)")
    public static Block parseUserAgent(@SqlType(value="varchar") Slice userAgentSlice) throws IllegalArgumentException {
        String userAgentStringToParse = null;
        if (userAgentSlice != null) {
            userAgentStringToParse = userAgentSlice.toStringUtf8();
        }
        UserAgentAnalyzer userAgentAnalyzer = threadLocalUserAgentAnalyzer.get();
        UserAgent.ImmutableUserAgent userAgent = userAgentAnalyzer.parse(userAgentStringToParse);
        Map resultMap = userAgent.toMap(userAgentAnalyzer.getAllPossibleFieldNamesSorted());
        MapType mapType = new MapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, new TypeOperators());
        BlockBuilder blockBuilder = mapType.createBlockBuilder(null, resultMap.size());
        BlockBuilder singleMapBlockBuilder = blockBuilder.beginBlockEntry();
        for (Map.Entry entry : resultMap.entrySet()) {
            VarcharType.VARCHAR.writeString(singleMapBlockBuilder, (String)entry.getKey());
            VarcharType.VARCHAR.writeString(singleMapBlockBuilder, (String)entry.getValue());
        }
        blockBuilder.closeEntry();
        return mapType.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }
}

