/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import nl.geodienstencentrum.maven.plugin.sass.Resource;
import nl.geodienstencentrum.maven.plugin.sass.compiler.CompilerCallback;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractSassMojo
extends AbstractMojo {
    @Parameter
    private List<Resource> resources = Collections.emptyList();
    @Parameter(defaultValue="${project.build.directory}/rubygems")
    private String[] gemPaths = new String[0];
    @Parameter
    private String[] gems = new String[0];
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDirectory;
    @Parameter(defaultValue="true")
    protected boolean failOnError;
    @Parameter
    private Map<String, String> sassOptions = new HashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)"unix_newlines", (Object)"true", (Object)"cache", (Object)"true", (Object)"always_update", (Object)"true", (Object)"style", (Object)":expanded"));
    @Parameter(defaultValue="false")
    private boolean useCompass;
    @Parameter(defaultValue="${basedir}/src/main/sass", property="sassSourceDirectory")
    private File sassSourceDirectory;
    @Parameter
    private String[] includes = new String[]{"**/scss"};
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="..")
    private String relativeOutputDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/css")
    private File destination;
    @Parameter(defaultValue="1.9")
    private Float rubyVersion;

    protected void executeSassScript(String string) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        System.setProperty("org.jruby.embed.localcontext.scope", "threadsafe");
        System.setProperty("org.jruby.embed.compat.version", String.format("ruby%2.0f", Float.valueOf(this.rubyVersion.floatValue() * 10.0f)));
        log.debug((CharSequence)("Setting 'org.jruby.embed.compat.version' to: " + String.format("ruby%2.0f", Float.valueOf(this.rubyVersion.floatValue() * 10.0f))));
        log.debug((CharSequence)("Execute Sass Ruby script:\n\n" + string));
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("jruby");
        try {
            CompilerCallback compilerCallback = new CompilerCallback(log);
            scriptEngine.getBindings(100).put("compiler_callback", (Object)compilerCallback);
            scriptEngine.eval(string);
            if (this.failOnError && compilerCallback.hadError()) {
                throw new MojoFailureException("Sass compilation encountered errors (see above for details).");
            }
        }
        catch (ScriptException scriptException) {
            throw new MojoExecutionException("Failed to execute Sass ruby script:\n" + string, (Exception)scriptException);
        }
        log.debug((CharSequence)"\n");
    }

    protected void buildBasicSassScript(StringBuilder stringBuilder) throws MojoExecutionException {
        String string;
        int n;
        Object object;
        Log log = this.getLog();
        stringBuilder.append("require 'rubygems'").append('\n');
        if (this.gemPaths.length > 0) {
            stringBuilder.append("env = { 'GEM_PATH' => [\n");
            for (String string2 : this.gemPaths) {
                stringBuilder.append("    '").append(string2).append("',\n");
            }
            object = System.getenv("GEM_PATH");
            if (object != null) {
                String[] stringArray = ((String)object).split(File.pathSeparator);
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    string = stringArray[i];
                    stringBuilder.append("    '").append(string).append("',\n");
                }
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append('\n');
            stringBuilder.append("] }").append('\n');
            stringBuilder.append("Gem.paths = env").append('\n');
        }
        object = this.gems;
        int n2 = ((String[])object).length;
        for (n = 0; n < n2; ++n) {
            String string3 = object[n];
            stringBuilder.append("require '").append(string3).append("'\n");
        }
        stringBuilder.append("require 'sass/plugin'\n");
        stringBuilder.append("require 'java'\n");
        if (this.useCompass) {
            log.info((CharSequence)"Running with Compass enabled.");
            stringBuilder.append("require 'compass'").append('\n');
            stringBuilder.append("require 'compass/exec'").append('\n');
            stringBuilder.append("require 'compass/core'").append('\n');
            stringBuilder.append("require 'compass/import-once'").append('\n');
            stringBuilder.append("Compass.add_project_configuration ").append('\n');
            this.sassOptions.put("load_paths", "Compass.configuration.sass_load_paths");
        }
        if ((object = this.getTemplateLocations()).hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            this.sassOptions.put("template_location", "'" + (String)entry.getKey() + "'");
            this.sassOptions.put("css_location", "'" + (String)entry.getValue() + "'");
        }
        if (!this.sassOptions.containsKey("cache_location")) {
            File file = new File(this.buildDirectory, "sass_cache");
            String string4 = file.toString();
            this.sassOptions.put("cache_location", "'" + FilenameUtils.separatorsToUnix((String)string4) + "'");
        }
        stringBuilder.append("Sass::Plugin.options.merge!(").append('\n');
        Object object2 = this.sassOptions.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry<String, String> entry = object2.next();
            String string5 = entry.getKey();
            string = entry.getValue();
            stringBuilder.append("    :").append(string5).append(" => ").append(string);
            if (object2.hasNext()) {
                stringBuilder.append(",");
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append(")").append('\n');
        while (object.hasNext()) {
            object2 = (Map.Entry)object.next();
            stringBuilder.append("Sass::Plugin.add_template_location('").append((String)object2.getKey()).append("', '").append((String)object2.getValue()).append("')").append('\n');
        }
        stringBuilder.append("Sass::Plugin.on_compilation_error {|error, template, css| $compiler_callback.compilationError(error.message, template, css) }").append('\n');
        stringBuilder.append("Sass::Plugin.on_updated_stylesheet {|template, css| $compiler_callback.updatedStylesheeet(template, css) }").append('\n');
        stringBuilder.append("Sass::Plugin.on_template_modified {|template| $compiler_callback.templateModified(template) }").append('\n');
        stringBuilder.append("Sass::Plugin.on_template_created {|template| $compiler_callback.templateCreated(template) }").append('\n');
        stringBuilder.append("Sass::Plugin.on_template_deleted {|template| $compiler_callback.templateDeleted(template) }").append('\n');
        if (log.isDebugEnabled()) {
            stringBuilder.append("require 'pp'").append('\n');
            stringBuilder.append("pp Sass::Plugin.options").append('\n');
            if (this.useCompass) {
                stringBuilder.append("pp Compass.base_directory").append('\n');
                stringBuilder.append("pp Compass::Core.base_directory").append('\n');
                stringBuilder.append("pp Compass::configuration").append('\n');
            }
        }
    }

    private Iterator<Map.Entry<String, String>> getTemplateLocations() {
        Object object;
        Log log = this.getLog();
        ImmutableList immutableList = this.resources;
        if (immutableList.isEmpty()) {
            log.info((CharSequence)"No resource element was specified, using short configuration.");
            object = new Resource();
            ((Resource)object).source = new FileSet();
            if (this.sassSourceDirectory != null) {
                log.debug((CharSequence)("Setting source directory: " + this.sassSourceDirectory.toString()));
                ((Resource)object).source.setDirectory(this.sassSourceDirectory.toString());
            } else {
                log.error((CharSequence)("\"" + this.sassSourceDirectory + "\" is not a directory."));
                ((Resource)object).source.setDirectory("./src/main/sass");
            }
            if (this.includes != null) {
                log.debug((CharSequence)("Setting includes: " + Arrays.toString(this.includes)));
                ((Resource)object).source.setIncludes(Arrays.asList(this.includes));
            }
            if (this.excludes != null) {
                log.debug((CharSequence)("Setting excludes: " + Arrays.toString(this.excludes)));
                ((Resource)object).source.setExcludes(Arrays.asList(this.excludes));
            }
            ((Resource)object).relativeOutputDirectory = this.relativeOutputDirectory;
            ((Resource)object).destination = this.destination;
            immutableList = ImmutableList.of((Object)object);
        }
        object = new ArrayList();
        for (Resource resource : immutableList) {
            for (Map.Entry<String, String> entry : resource.getDirectoriesAndDestinations().entrySet()) {
                log.info((CharSequence)("Queueing Sass template for compile: " + entry.getKey() + " => " + entry.getValue()));
                object.add(entry);
            }
        }
        return object.iterator();
    }

    protected List<Resource> getResources() {
        return this.resources;
    }

    protected boolean isUseCompass() {
        return this.useCompass;
    }

    protected File getSassSourceDirectory() {
        return this.sassSourceDirectory;
    }
}

