/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass.report;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import nl.geodienstencentrum.maven.plugin.sass.Resource;
import nl.geodienstencentrum.maven.plugin.sass.report.SCSSLintReportGenerator;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;

@Mojo(name="scss-lint-report", defaultPhase=LifecyclePhase.SITE, threadSafe=true)
@Execute(goal="scss-lint", phase=LifecyclePhase.COMPILE)
public class SCSSLintReportMojo
extends AbstractMavenReport {
    @Parameter
    private Map<String, String> sassOptions;
    @Parameter(defaultValue="false")
    private boolean useCompass;
    @Parameter(defaultValue="${basedir}/src/main/sass", property="sassSourceDirectory")
    private File sassSourceDirectory;
    @Parameter
    private List<Resource> resources = Collections.emptyList();
    @Parameter(defaultValue="false")
    private boolean failOnError;
    @Parameter(defaultValue="scss-lint", property="outputName", required=true)
    private String outputName;
    @Parameter(defaultValue="${project.build.directory}/site/", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private Renderer siteRenderer;

    public void executeReport(Locale locale) {
        block2: {
            try {
                SCSSLintReportGenerator sCSSLintReportGenerator = new SCSSLintReportGenerator(this.getSink(), this.getDescription(locale), new File(this.getProject().getBasedir() + "/target", "scss-lint.xml"), this.getLog());
                sCSSLintReportGenerator.generateReport();
            }
            catch (Exception exception) {
                if (!this.failOnError) break block2;
                throw exception;
            }
        }
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    public void setReportOutputDirectory(File file) {
        this.outputDirectory = file;
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public String getName(Locale locale) {
        return "scss-lint report";
    }

    public String getDescription(Locale locale) {
        return "A scss-lint report.";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("scss-lint-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

