/*
 * Decompiled with CFR 0.152.
 */
package nl.komponents.kovenant;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import nl.komponents.kovenant.BlockingPollStrategyFactory;
import nl.komponents.kovenant.BlockingSleepPollStrategyFactory;
import nl.komponents.kovenant.BusyPollStrategyFactory;
import nl.komponents.kovenant.ChainPollStrategyFactory;
import nl.komponents.kovenant.PollStrategy;
import nl.komponents.kovenant.PollStrategyBuilder;
import nl.komponents.kovenant.PollStrategyFactory;
import nl.komponents.kovenant.Pollable;
import nl.komponents.kovenant.SleepingPollStrategyFactory;
import nl.komponents.kovenant.YieldingPollStrategyFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0011J(\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\u0014\u001a\u00020\u0007J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnl/komponents/kovenant/ConcretePollStrategyBuilder;", "Lnl/komponents/kovenant/PollStrategyBuilder;", "()V", "factories", "Ljava/util/ArrayList;", "Lnl/komponents/kovenant/PollStrategyFactory;", "Lkotlin/Function0;", "", "blocking", "blockingSleep", "numberOfPolls", "", "sleepTimeInMs", "", "build", "Lnl/komponents/kovenant/PollStrategy;", "pollable", "Lnl/komponents/kovenant/Pollable;", "buildDefaultStrategy", "busy", "clear", "sleeping", "yielding", "kovenant-core-compileKotlin"})
public final class ConcretePollStrategyBuilder
implements PollStrategyBuilder {
    private final ArrayList<PollStrategyFactory<Function0<Unit>>> factories = new ArrayList();

    public final void clear() {
        this.factories.clear();
    }

    @Override
    public void yielding(int numberOfPolls) {
        this.factories.add(new YieldingPollStrategyFactory(numberOfPolls));
    }

    @Override
    public void sleeping(int numberOfPolls, long sleepTimeInMs) {
        this.factories.add(new SleepingPollStrategyFactory(numberOfPolls, sleepTimeInMs));
    }

    @Override
    public void busy(int numberOfPolls) {
        this.factories.add(new BusyPollStrategyFactory(numberOfPolls));
    }

    @Override
    public void blocking() {
        this.factories.add(new BlockingPollStrategyFactory());
    }

    @Override
    public void blockingSleep(int numberOfPolls, long sleepTimeInMs) {
        this.factories.add(new BlockingSleepPollStrategyFactory(numberOfPolls, sleepTimeInMs));
    }

    private final PollStrategy<Function0<Unit>> buildDefaultStrategy(Pollable<Function0<Unit>> pollable) {
        List defaultFactories = CollectionsKt.listOf((Object[])new PollStrategyFactory[]{new YieldingPollStrategyFactory(0, 1, null), new SleepingPollStrategyFactory(0, 0L, 3, null)});
        return new ChainPollStrategyFactory<Function0<Unit>>(defaultFactories).build(pollable);
    }

    @NotNull
    public final PollStrategy<Function0<Unit>> build(@NotNull Pollable<Function0<Unit>> pollable) {
        Intrinsics.checkParameterIsNotNull(pollable, (String)"pollable");
        return this.factories.isEmpty() ? this.buildDefaultStrategy(pollable) : new ChainPollStrategyFactory<Function0<Unit>>((List)this.factories).build(pollable);
    }
}

