/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.Version;
import weka.core.xml.PropertyHandler;
import weka.core.xml.XMLDocument;
import weka.core.xml.XMLSerializationMethodHandler;

public class XMLSerialization
implements RevisionHandler {
    protected static boolean DEBUG = false;
    protected Element m_CurrentNode = null;
    public static final String TAG_OBJECT = "object";
    public static final String ATT_VERSION = "version";
    public static final String ATT_NAME = "name";
    public static final String ATT_CLASS = "class";
    public static final String ATT_PRIMITIVE = "primitive";
    public static final String ATT_ARRAY = "array";
    public static final String ATT_NULL = "null";
    public static final String VAL_YES = "yes";
    public static final String VAL_NO = "no";
    public static final String VAL_ROOT = "__root__";
    public static final String ROOT_NODE = "object";
    public static final String ATT_PRIMITIVE_DEFAULT = "no";
    public static final String ATT_ARRAY_DEFAULT = "no";
    public static final String ATT_NULL_DEFAULT = "no";
    public static final String DOCTYPE = "<!DOCTYPE object\n[\n   <!ELEMENT object (#PCDATA|object)*>\n   <!ATTLIST object name      CDATA #REQUIRED>\n   <!ATTLIST object class     CDATA #REQUIRED>\n   <!ATTLIST object primitive CDATA \"no\">\n   <!ATTLIST object array     CDATA \"no\">   <!-- the dimensions of the array; no=0, yes=1 -->\n   <!ATTLIST object null      CDATA \"no\">\n   <!ATTLIST object version   CDATA \"" + Version.VERSION + "\">\n" + "]\n" + ">";
    protected XMLDocument m_Document = null;
    protected PropertyHandler m_Properties = null;
    protected XMLSerializationMethodHandler m_CustomMethods = null;
    protected Hashtable<Class, String> m_ClassnameOverride = null;

    public XMLSerialization() throws Exception {
        this.clear();
    }

    protected void trace(Throwable t, String msg) {
        if (DEBUG && t.getStackTrace().length > 0) {
            System.out.println("trace: " + t.getStackTrace()[0] + ": " + msg);
        }
    }

    public void clear() throws Exception {
        this.m_Document = new XMLDocument();
        this.m_Document.setValidating(true);
        this.m_Document.newDocument(DOCTYPE, "object");
        this.m_Properties = new PropertyHandler();
        this.m_CustomMethods = new XMLSerializationMethodHandler(this);
        this.m_ClassnameOverride = new Hashtable();
        this.m_ClassnameOverride.put(File.class, File.class.getName());
        this.setVersion(Version.VERSION);
        this.m_CurrentNode = null;
    }

    private void setVersion(String version) {
        Document doc = this.m_Document.getDocument();
        doc.getDocumentElement().setAttribute(ATT_VERSION, version);
    }

    public String getVersion() {
        Document doc = this.m_Document.getDocument();
        String result = doc.getDocumentElement().getAttribute(ATT_VERSION);
        return result;
    }

    private void checkVersion() {
        Version version = new Version();
        String versionStr = this.getVersion();
        if (versionStr.equals("")) {
            System.out.println("WARNING: has no version!");
        } else if (version.isOlder(versionStr)) {
            System.out.println("WARNING: loading a newer version (" + versionStr + " > " + Version.VERSION + ")!");
        } else if (version.isNewer(versionStr)) {
            System.out.println("NOTE: loading an older version (" + versionStr + " < " + Version.VERSION + ")!");
        }
    }

    protected Hashtable getDescriptors(Object o) throws Exception {
        Hashtable<String, PropertyDescriptor> result = new Hashtable<String, PropertyDescriptor>();
        BeanInfo info = Introspector.getBeanInfo(o.getClass());
        PropertyDescriptor[] desc = info.getPropertyDescriptors();
        for (int i = 0; i < desc.length; ++i) {
            if (desc[i].getReadMethod() == null || desc[i].getWriteMethod() == null || this.m_Properties.isIgnored(desc[i].getDisplayName()) || this.m_Properties.isIgnored(o, desc[i].getDisplayName()) || !this.m_Properties.isAllowed(o, desc[i].getDisplayName())) continue;
            result.put(desc[i].getDisplayName(), desc[i]);
        }
        return result;
    }

    protected String getPath(Element node) {
        String result = node.getAttribute(ATT_NAME);
        while (node.getParentNode() != node.getOwnerDocument()) {
            node = (Element)node.getParentNode();
            result = node.getAttribute(ATT_NAME) + "." + result;
        }
        return result;
    }

    protected String booleanToString(boolean b) {
        if (b) {
            return VAL_YES;
        }
        return "no";
    }

    protected boolean stringToBoolean(String s) {
        if (s.equals("")) {
            return false;
        }
        if (s.equals(VAL_YES)) {
            return true;
        }
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.replaceAll("[0-9]*", "").equals("")) {
            return Integer.parseInt(s) != 0;
        }
        return false;
    }

    protected Element addElement(Element parent, String name, String classname, boolean primitive) {
        return this.addElement(parent, name, classname, primitive, 0);
    }

    protected Element addElement(Element parent, String name, String classname, boolean primitive, int array) {
        return this.addElement(parent, name, classname, primitive, array, false);
    }

    protected Element addElement(Element parent, String name, String classname, boolean primitive, int array, boolean isnull) {
        Element result = parent == null ? this.m_Document.getDocument().getDocumentElement() : (Element)parent.appendChild(this.m_Document.getDocument().createElement("object"));
        result.setAttribute(ATT_NAME, name);
        result.setAttribute(ATT_CLASS, classname);
        if (!this.booleanToString(primitive).equals("no")) {
            result.setAttribute(ATT_PRIMITIVE, this.booleanToString(primitive));
        }
        if (array > 1) {
            result.setAttribute(ATT_ARRAY, Integer.toString(array));
        } else if (!this.booleanToString(array == 1).equals("no")) {
            result.setAttribute(ATT_ARRAY, this.booleanToString(array == 1));
        }
        if (!this.booleanToString(isnull).equals("no")) {
            result.setAttribute(ATT_NULL, this.booleanToString(isnull));
        }
        return result;
    }

    protected String overrideClassname(Object o) {
        String result = o.getClass().getName();
        Enumeration<Class> enm = this.m_ClassnameOverride.keys();
        while (enm.hasMoreElements()) {
            Class currentCls = enm.nextElement();
            if (!currentCls.isInstance(o)) continue;
            result = this.m_ClassnameOverride.get(currentCls);
            break;
        }
        return result;
    }

    protected String overrideClassname(String classname) {
        String result = classname;
        Enumeration<Class> enm = this.m_ClassnameOverride.keys();
        while (enm.hasMoreElements()) {
            Class currentCls = enm.nextElement();
            if (!currentCls.getName().equals(classname)) continue;
            result = this.m_ClassnameOverride.get(currentCls);
            break;
        }
        return result;
    }

    protected PropertyDescriptor determineDescriptor(String className, String displayName) {
        PropertyDescriptor result = null;
        try {
            result = new PropertyDescriptor(displayName, Class.forName(className));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    protected Element writeBooleanToXML(Element parent, boolean o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Element node = this.addElement(parent, name, Boolean.TYPE.getName(), true);
        node.appendChild(node.getOwnerDocument().createTextNode(new Boolean(o).toString()));
        return node;
    }

    protected Element writeByteToXML(Element parent, byte o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Element node = this.addElement(parent, name, Byte.TYPE.getName(), true);
        node.appendChild(node.getOwnerDocument().createTextNode(new Byte(o).toString()));
        return node;
    }

    protected Element writeCharToXML(Element parent, char o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Element node = this.addElement(parent, name, Character.TYPE.getName(), true);
        node.appendChild(node.getOwnerDocument().createTextNode(new Character(o).toString()));
        return node;
    }

    protected Element writeDoubleToXML(Element parent, double o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Element node = this.addElement(parent, name, Double.TYPE.getName(), true);
        node.appendChild(node.getOwnerDocument().createTextNode(new Double(o).toString()));
        return node;
    }

    protected Element writeFloatToXML(Element parent, float o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Element node = this.addElement(parent, name, Float.TYPE.getName(), true);
        node.appendChild(node.getOwnerDocument().createTextNode(new Float(o).toString()));
        return node;
    }

    protected Element writeIntToXML(Element parent, int o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Element node = this.addElement(parent, name, Integer.TYPE.getName(), true);
        node.appendChild(node.getOwnerDocument().createTextNode(new Integer(o).toString()));
        return node;
    }

    protected Element writeLongToXML(Element parent, long o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Element node = this.addElement(parent, name, Long.TYPE.getName(), true);
        node.appendChild(node.getOwnerDocument().createTextNode(new Long(o).toString()));
        return node;
    }

    protected Element writeShortToXML(Element parent, short o, String name) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), name);
        }
        this.m_CurrentNode = parent;
        Element node = this.addElement(parent, name, Short.TYPE.getName(), true);
        node.appendChild(node.getOwnerDocument().createTextNode(new Short(o).toString()));
        return node;
    }

    protected boolean isPrimitiveArray(Class c) {
        if (c.getComponentType().isArray()) {
            return this.isPrimitiveArray(c.getComponentType());
        }
        return c.getComponentType().isPrimitive();
    }

    public Element writeToXML(Element parent, Object o, String name) throws Exception {
        Element node;
        block12: {
            Hashtable memberlist;
            PropertyDescriptor desc;
            block14: {
                block13: {
                    boolean primitive;
                    block11: {
                        String classname;
                        node = null;
                        if (DEBUG) {
                            this.trace(new Throwable(), name);
                        }
                        if (o == null) {
                            node = this.addElement(parent, name, "" + null, false, 0, true);
                            return node;
                        }
                        Object obj = null;
                        int array = 0;
                        if (o.getClass().isArray()) {
                            array = Utils.getArrayDimensions(o);
                        }
                        if (array > 0) {
                            classname = Utils.getArrayClass(o.getClass()).getName();
                            primitive = this.isPrimitiveArray(o.getClass());
                        } else {
                            desc = null;
                            if (parent != null) {
                                desc = this.determineDescriptor(parent.getAttribute(ATT_CLASS), name);
                            }
                            if (primitive = desc != null ? desc.getPropertyType().isPrimitive() : o.getClass().isPrimitive()) {
                                classname = desc.getPropertyType().getName();
                            } else {
                                obj = o;
                                classname = o.getClass().getName();
                            }
                        }
                        if (parent != null && !parent.getAttribute(ATT_ARRAY).equals("") && !parent.getAttribute(ATT_ARRAY).equals("no") && this.stringToBoolean(parent.getAttribute(ATT_PRIMITIVE))) {
                            primitive = true;
                            classname = parent.getAttribute(ATT_CLASS);
                            obj = null;
                        }
                        classname = obj != null ? this.overrideClassname(obj) : this.overrideClassname(classname);
                        node = this.addElement(parent, name, classname, primitive, array);
                        if (array <= 0) break block11;
                        for (int i = 0; i < Array.getLength(o); ++i) {
                            this.invokeWriteToXML(node, Array.get(o, i), Integer.toString(i));
                        }
                        break block12;
                    }
                    if (!primitive) break block13;
                    node.appendChild(node.getOwnerDocument().createTextNode(o.toString()));
                    break block12;
                }
                memberlist = this.getDescriptors(o);
                if (memberlist.size() != 0) break block14;
                if (o.toString().equals("")) break block12;
                String tmpStr = o.toString();
                tmpStr = tmpStr.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                tmpStr = tmpStr.replaceAll("\n", "&#10;").replaceAll("\r", "&#13;").replaceAll("\t", "&#9;");
                node.appendChild(node.getOwnerDocument().createTextNode(tmpStr));
                break block12;
            }
            Enumeration enm = memberlist.keys();
            while (enm.hasMoreElements()) {
                String memberName = enm.nextElement().toString();
                if (this.m_Properties.isIgnored(memberName) || this.m_Properties.isIgnored(this.getPath(node) + "." + memberName) || this.m_Properties.isIgnored(o, this.getPath(node) + "." + memberName) || !this.m_Properties.isAllowed(o, memberName)) continue;
                desc = (PropertyDescriptor)memberlist.get(memberName);
                Method method = desc.getReadMethod();
                Object member = method.invoke(o, (Object[])null);
                this.invokeWriteToXML(node, member, memberName);
            }
        }
        return node;
    }

    protected Element invokeWriteToXML(Element parent, Object o, String name) throws Exception {
        Element node = null;
        Method method = null;
        boolean useDefault = false;
        this.m_CurrentNode = parent;
        if (o == null) {
            useDefault = true;
        }
        try {
            if (!useDefault) {
                boolean array = o.getClass().isArray();
                method = this.m_CustomMethods.write().contains(name) ? this.m_CustomMethods.write().get(o.getClass()) : (!array && this.m_CustomMethods.write().contains(o.getClass()) ? this.m_CustomMethods.write().get(o.getClass()) : null);
                boolean bl = useDefault = method == null;
            }
            if (!useDefault) {
                Class[] methodClasses = new Class[]{Element.class, Object.class, String.class};
                Object[] methodArgs = new Object[]{parent, o, name};
                node = (Element)method.invoke((Object)this, methodArgs);
            } else {
                node = this.writeToXML(parent, o, name);
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            if (this.m_CurrentNode != null) {
                System.out.println("Happened near: " + this.getPath(this.m_CurrentNode));
                this.m_CurrentNode = null;
            }
            System.out.println("PROBLEM (write): " + name);
            throw (Exception)e.fillInStackTrace();
        }
        return node;
    }

    protected Object writePreProcess(Object o) throws Exception {
        return o;
    }

    protected void writePostProcess(Object o) throws Exception {
    }

    public XMLDocument toXML(Object o) throws Exception {
        this.clear();
        this.invokeWriteToXML(null, this.writePreProcess(o), VAL_ROOT);
        this.writePostProcess(o);
        return this.m_Document;
    }

    protected PropertyDescriptor getDescriptorByName(Object o, String name) throws Exception {
        PropertyDescriptor result = null;
        PropertyDescriptor[] desc = Introspector.getBeanInfo(o.getClass()).getPropertyDescriptors();
        for (int i = 0; i < desc.length; ++i) {
            if (!desc[i].getDisplayName().equals(name)) continue;
            result = desc[i];
            break;
        }
        return result;
    }

    protected Class determineClass(String name) throws Exception {
        Class<Serializable> result = name.equals(Boolean.TYPE.getName()) ? Boolean.TYPE : (name.equals(Byte.TYPE.getName()) ? Byte.TYPE : (name.equals(Character.TYPE.getName()) ? Character.TYPE : (name.equals(Double.TYPE.getName()) ? Double.TYPE : (name.equals(Float.TYPE.getName()) ? Float.TYPE : (name.equals(Integer.TYPE.getName()) ? Integer.TYPE : (name.equals(Long.TYPE.getName()) ? Long.TYPE : (name.equals(Short.TYPE.getName()) ? Short.TYPE : Class.forName(name))))))));
        return result;
    }

    protected Object getPrimitive(Element node) throws Exception {
        Class cls = this.determineClass(node.getAttribute(ATT_CLASS));
        Object tmpResult = Array.newInstance(cls, 1);
        if (cls == Boolean.TYPE) {
            Array.set(tmpResult, 0, new Boolean(XMLDocument.getContent(node)));
        } else if (cls == Byte.TYPE) {
            Array.set(tmpResult, 0, new Byte(XMLDocument.getContent(node)));
        } else if (cls == Character.TYPE) {
            Array.set(tmpResult, 0, new Character(XMLDocument.getContent(node).charAt(0)));
        } else if (cls == Double.TYPE) {
            Array.set(tmpResult, 0, new Double(XMLDocument.getContent(node)));
        } else if (cls == Float.TYPE) {
            Array.set(tmpResult, 0, new Float(XMLDocument.getContent(node)));
        } else if (cls == Integer.TYPE) {
            Array.set(tmpResult, 0, new Integer(XMLDocument.getContent(node)));
        } else if (cls == Long.TYPE) {
            Array.set(tmpResult, 0, new Long(XMLDocument.getContent(node)));
        } else if (cls == Short.TYPE) {
            Array.set(tmpResult, 0, new Short(XMLDocument.getContent(node)));
        } else {
            throw new Exception("Cannot get primitive for class '" + cls.getName() + "'!");
        }
        Object result = Array.get(tmpResult, 0);
        return result;
    }

    public boolean readBooleanFromXML(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = node;
        return (Boolean)this.getPrimitive(node);
    }

    public byte readByteFromXML(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = node;
        return (Byte)this.getPrimitive(node);
    }

    public char readCharFromXML(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = node;
        return ((Character)this.getPrimitive(node)).charValue();
    }

    public double readDoubleFromXML(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = node;
        return (Double)this.getPrimitive(node);
    }

    public float readFloatFromXML(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = node;
        return ((Float)this.getPrimitive(node)).floatValue();
    }

    public int readIntFromXML(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = node;
        return (Integer)this.getPrimitive(node);
    }

    public long readLongFromXML(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = node;
        return (Long)this.getPrimitive(node);
    }

    public short readShortFromXML(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = node;
        return (Short)this.getPrimitive(node);
    }

    public Object readFromXML(Object o, String name, Element child) throws Exception {
        Object result = o;
        Hashtable descriptors = this.getDescriptors(result);
        String methodName = child.getAttribute(ATT_NAME);
        if (this.m_Properties.isIgnored(this.getPath(child))) {
            return result;
        }
        if (this.m_Properties.isIgnored(result, this.getPath(child))) {
            return result;
        }
        if (!this.m_Properties.isAllowed(result, methodName)) {
            return result;
        }
        PropertyDescriptor descriptor = (PropertyDescriptor)descriptors.get(methodName);
        if (descriptor == null) {
            if (!this.m_CustomMethods.read().contains(methodName)) {
                System.out.println("WARNING: unknown property '" + name + "." + methodName + "'!");
            }
            return result;
        }
        Method method = descriptor.getWriteMethod();
        Object[] methodArgs = new Object[1];
        Object tmpResult = this.invokeReadFromXML(child);
        Class<?> paramClass = method.getParameterTypes()[0];
        if (paramClass.isArray()) {
            if (Array.getLength(tmpResult) == 0) {
                return result;
            }
            methodArgs[0] = (Object[])tmpResult;
        } else {
            methodArgs[0] = tmpResult;
        }
        method.invoke(result, methodArgs);
        return result;
    }

    protected int[] getArrayDimensions(Element node) {
        int[] result;
        Vector<Element> children = this.stringToBoolean(node.getAttribute(ATT_ARRAY)) ? XMLDocument.getChildTags(node) : null;
        if (children != null) {
            int i;
            Vector<Integer> tmpVector = new Vector<Integer>();
            if (children.size() > 0) {
                int[] tmp = this.getArrayDimensions(children.get(0));
                if (tmp != null) {
                    for (i = tmp.length - 1; i >= 0; --i) {
                        tmpVector.add(new Integer(tmp[i]));
                    }
                }
                tmpVector.add(0, new Integer(children.size()));
            } else {
                tmpVector.add(new Integer(0));
            }
            result = new int[tmpVector.size()];
            for (i = 0; i < result.length; ++i) {
                result[i] = (Integer)tmpVector.get(tmpVector.size() - i - 1);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Object readFromXML(Element node) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), node.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = node;
        Object result = null;
        String name = node.getAttribute(ATT_NAME);
        String classname = node.getAttribute(ATT_CLASS);
        boolean primitive = this.stringToBoolean(node.getAttribute(ATT_PRIMITIVE));
        boolean array = this.stringToBoolean(node.getAttribute(ATT_ARRAY));
        boolean isnull = this.stringToBoolean(node.getAttribute(ATT_NULL));
        if (isnull) {
            return result;
        }
        Vector<Element> children = XMLDocument.getChildTags(node);
        Class cls = this.determineClass(classname);
        if (array) {
            result = Array.newInstance(cls, this.getArrayDimensions(node));
            for (int i = 0; i < children.size(); ++i) {
                Element child = children.get(i);
                Array.set(result, Integer.parseInt(child.getAttribute(ATT_NAME)), this.invokeReadFromXML(child));
            }
        } else if (children.size() == 0) {
            if (primitive) {
                result = this.getPrimitive(node);
            } else {
                Class[] methodClasses = new Class[]{String.class};
                Object[] methodArgs = new Object[]{XMLDocument.getContent(node)};
                try {
                    Constructor constructor = cls.getConstructor(methodClasses);
                    result = constructor.newInstance(methodArgs);
                }
                catch (Exception e) {
                    try {
                        result = cls.newInstance();
                    }
                    catch (Exception e2) {
                        result = null;
                        System.out.println("ERROR: Can't instantiate '" + classname + "'!");
                    }
                }
            }
        } else {
            result = cls.newInstance();
            for (int i = 0; i < children.size(); ++i) {
                result = this.readFromXML(result, name, children.get(i));
            }
        }
        return result;
    }

    protected Object invokeReadFromXML(Element node) throws Exception {
        boolean useDefault = false;
        Method method = null;
        this.m_CurrentNode = node;
        try {
            if (this.stringToBoolean(node.getAttribute(ATT_NULL))) {
                useDefault = true;
            }
            if (!useDefault) {
                boolean array = this.stringToBoolean(node.getAttribute(ATT_ARRAY));
                method = this.m_CustomMethods.read().contains(node.getAttribute(ATT_NAME)) ? this.m_CustomMethods.read().get(node.getAttribute(ATT_NAME)) : (!array && this.m_CustomMethods.read().contains(this.determineClass(node.getAttribute(ATT_CLASS))) ? this.m_CustomMethods.read().get(this.determineClass(node.getAttribute(ATT_CLASS))) : null);
                boolean bl = useDefault = method == null;
            }
            if (!useDefault) {
                Class[] methodClasses = new Class[]{Element.class};
                Object[] methodArgs = new Object[]{node};
                return method.invoke((Object)this, methodArgs);
            }
            return this.readFromXML(node);
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            if (this.m_CurrentNode != null) {
                System.out.println("Happened near: " + this.getPath(this.m_CurrentNode));
                this.m_CurrentNode = null;
            }
            System.out.println("PROBLEM (read): " + node.getAttribute(ATT_NAME));
            throw (Exception)e.fillInStackTrace();
        }
    }

    protected Document readPreProcess(Document document) throws Exception {
        return document;
    }

    protected Object readPostProcess(Object o) throws Exception {
        return o;
    }

    public Object fromXML(Document document) throws Exception {
        if (!document.getDocumentElement().getNodeName().equals("object")) {
            throw new Exception("Expected 'object' as root element, but found '" + document.getDocumentElement().getNodeName() + "'!");
        }
        this.m_Document.setDocument(this.readPreProcess(document));
        this.checkVersion();
        return this.readPostProcess(this.invokeReadFromXML(this.m_Document.getDocument().getDocumentElement()));
    }

    public Object read(String xml) throws Exception {
        return this.fromXML(this.m_Document.read(xml));
    }

    public Object read(File file) throws Exception {
        return this.fromXML(this.m_Document.read(file));
    }

    public Object read(InputStream stream) throws Exception {
        return this.fromXML(this.m_Document.read(stream));
    }

    public Object read(Reader reader) throws Exception {
        return this.fromXML(this.m_Document.read(reader));
    }

    public void write(String file, Object o) throws Exception {
        this.toXML(o).write(file);
    }

    public void write(File file, Object o) throws Exception {
        this.toXML(o).write(file);
    }

    public void write(OutputStream stream, Object o) throws Exception {
        this.toXML(o).write(stream);
    }

    public void write(Writer writer, Object o) throws Exception {
        this.toXML(o).write(writer);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            if (args[0].toLowerCase().endsWith(".xml")) {
                System.out.println(new XMLSerialization().read(args[0]).toString());
            } else {
                FileInputStream fi = new FileInputStream(args[0]);
                ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(fi));
                Object o = oi.readObject();
                oi.close();
                new XMLSerialization().write(new BufferedOutputStream(new FileOutputStream(args[0] + ".xml")), o);
                FileOutputStream fo = new FileOutputStream(args[0] + ".exp");
                ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(fo));
                oo.writeObject(o);
                oo.close();
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

