/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import weka.gui.Logger;

public class LogPanel
extends JPanel
implements Logger {
    protected HashMap<String, Integer> m_tableIndexes = new HashMap();
    private HashMap<String, Timer> m_timers = new HashMap();
    private final DefaultTableModel m_tableModel;
    private JTable m_table;
    private JTabbedPane m_tabs = new JTabbedPane();
    private weka.gui.LogPanel m_logPanel = new weka.gui.LogPanel(null, false, true, false);

    public LogPanel() {
        Object[] columnNames = new String[]{"Component", "Parameters", "Time", "Status"};
        this.m_tableModel = new DefaultTableModel(columnNames, 0);
        this.m_table = new JTable(){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (!c.getBackground().equals(this.getSelectionBackground())) {
                    String type = (String)this.getModel().getValueAt(row, 3);
                    Color backgroundIndicator = null;
                    if (type.startsWith("ERROR")) {
                        backgroundIndicator = Color.RED;
                    } else if (type.startsWith("WARNING")) {
                        backgroundIndicator = Color.YELLOW;
                    } else if (type.startsWith("INTERRUPTED")) {
                        backgroundIndicator = Color.MAGENTA;
                    }
                    c.setBackground(backgroundIndicator);
                }
                return c;
            }
        };
        this.m_table.setModel(this.m_tableModel);
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.m_table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.m_table.getColumnModel().getColumn(2).setPreferredWidth(30);
        this.m_table.getColumnModel().getColumn(3).setPreferredWidth(400);
        this.m_table.setShowVerticalLines(true);
        JPanel statusPan = new JPanel();
        statusPan.setLayout(new BorderLayout());
        statusPan.add((Component)new JScrollPane(this.m_table), "Center");
        this.m_tabs.addTab("Status", statusPan);
        this.m_tabs.addTab("Log", this.m_logPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tabs, "Center");
    }

    public void clearStatus() {
        Iterator<Timer> i = this.m_timers.values().iterator();
        while (i.hasNext()) {
            i.next().stop();
        }
        this.m_timers.clear();
        this.m_tableIndexes.clear();
        while (this.m_tableModel.getRowCount() > 0) {
            this.m_tableModel.removeRow(0);
        }
    }

    public JTable getStatusTable() {
        return this.m_table;
    }

    @Override
    public synchronized void logMessage(String message) {
        this.m_logPanel.logMessage(message);
    }

    @Override
    public synchronized void statusMessage(String message) {
        boolean hasDelimiters = message.indexOf(124) > 0;
        String stepName = "";
        String stepHash = "";
        String stepParameters = "";
        String stepStatus = "";
        if (!hasDelimiters) {
            stepName = "Unknown";
            stepHash = "Unknown";
            stepStatus = message;
        } else {
            stepHash = message.substring(0, message.indexOf(124));
            message = message.substring(message.indexOf(124) + 1, message.length());
            stepName = stepHash.indexOf(36) > 0 ? stepHash.substring(0, stepHash.indexOf(36)) : stepHash;
            if (message.indexOf(124) >= 0) {
                stepParameters = message.substring(0, message.indexOf(124));
                stepStatus = message.substring(message.indexOf(124) + 1, message.length());
            } else {
                stepStatus = message;
            }
        }
        if (this.m_tableIndexes.containsKey(stepHash)) {
            final Integer rowNum = this.m_tableIndexes.get(stepHash);
            if (stepStatus.equalsIgnoreCase("remove") || stepStatus.equalsIgnoreCase("remove.")) {
                this.m_tableIndexes.remove(stepHash);
                this.m_timers.get(stepHash).stop();
                this.m_timers.remove(stepHash);
                for (String nextKey : this.m_tableIndexes.keySet()) {
                    int index = this.m_tableIndexes.get(nextKey);
                    if (index <= rowNum) continue;
                    this.m_tableIndexes.put(nextKey, --index);
                }
                if (!SwingUtilities.isEventDispatchThread()) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LogPanel.this.m_tableModel.removeRow(rowNum);
                            }
                        });
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    this.m_tableModel.removeRow(rowNum);
                }
            } else {
                final String stepNameCopy = stepName;
                final String stepStatusCopy = stepStatus;
                final String stepParametersCopy = stepParameters;
                if (!SwingUtilities.isEventDispatchThread()) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!stepStatusCopy.startsWith("INTERRUPTED") || !((String)LogPanel.this.m_tableModel.getValueAt(rowNum, 3)).startsWith("ERROR")) {
                                    LogPanel.this.m_tableModel.setValueAt(stepNameCopy, rowNum, 0);
                                    LogPanel.this.m_tableModel.setValueAt(stepParametersCopy, rowNum, 1);
                                    LogPanel.this.m_tableModel.setValueAt(LogPanel.this.m_table.getValueAt(rowNum, 2), rowNum, 2);
                                    LogPanel.this.m_tableModel.setValueAt(stepStatusCopy, rowNum, 3);
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (!stepStatusCopy.startsWith("INTERRUPTED") || !((String)this.m_tableModel.getValueAt(rowNum, 3)).startsWith("ERROR")) {
                    this.m_tableModel.setValueAt(stepNameCopy, rowNum, 0);
                    this.m_tableModel.setValueAt(stepParametersCopy, rowNum, 1);
                    this.m_tableModel.setValueAt(this.m_table.getValueAt(rowNum, 2), rowNum, 2);
                    this.m_tableModel.setValueAt(stepStatusCopy, rowNum, 3);
                }
                if (stepStatus.startsWith("ERROR") || stepStatus.startsWith("INTERRUPTED") || stepStatus.toLowerCase().startsWith("finished") || stepStatus.toLowerCase().startsWith("done") || stepStatus.equalsIgnoreCase("stopped") || stepStatus.equalsIgnoreCase("stopped.")) {
                    this.m_timers.get(stepHash).stop();
                } else if (!this.m_timers.get(stepHash).isRunning()) {
                    this.installTimer(stepHash);
                }
            }
        } else if (!stepStatus.equalsIgnoreCase("Remove") && !stepStatus.equalsIgnoreCase("Remove.")) {
            int numKeys = this.m_tableIndexes.keySet().size();
            this.m_tableIndexes.put(stepHash, numKeys);
            final Object[] newRow = new Object[]{stepName, stepParameters, "-", stepStatus};
            String stepHashCopy = stepHash;
            try {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LogPanel.this.m_tableModel.addRow(newRow);
                        }
                    });
                } else {
                    this.m_tableModel.addRow(newRow);
                }
                this.installTimer(stepHashCopy);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void installTimer(final String stepHash) {
        final long startTime = System.currentTimeMillis();
        Timer newTimer = new Timer(1000, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                LogPanel logPanel = LogPanel.this;
                synchronized (logPanel) {
                    if (LogPanel.this.m_tableIndexes.containsKey(stepHash)) {
                        final Integer rn = LogPanel.this.m_tableIndexes.get(stepHash);
                        long elapsed = System.currentTimeMillis() - startTime;
                        long seconds = elapsed / 1000L;
                        long minutes = seconds / 60L;
                        final long hours = minutes / 60L;
                        seconds -= minutes * 60L;
                        final long seconds2 = seconds;
                        final long minutes2 = minutes -= hours * 60L;
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        LogPanel.this.m_tableModel.setValueAt("" + hours + ":" + minutes2 + ":" + seconds2, rn, 2);
                                    }
                                });
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            LogPanel.this.m_tableModel.setValueAt("" + hours + ":" + minutes2 + ":" + seconds2, rn, 2);
                        }
                    }
                }
            }
        });
        this.m_timers.put(stepHash, newTimer);
        newTimer.start();
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Status/Log Panel");
            jf.getContentPane().setLayout(new BorderLayout());
            LogPanel lp = new LogPanel();
            jf.getContentPane().add((Component)lp, "Center");
            jf.getContentPane().add((Component)lp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            lp.statusMessage("Step 1|Some options here|A status message");
            lp.statusMessage("Step 2$hashkey|Status message: no options");
            Thread.sleep(3000L);
            lp.statusMessage("Step 2$hashkey|Funky Chickens!!!");
            Thread.sleep(3000L);
            lp.statusMessage("Step 1|Some options here|finished");
            Thread.sleep(3000L);
            lp.statusMessage("Step 2$hashkey|ERROR! More Funky Chickens!!!");
            Thread.sleep(3000L);
            lp.statusMessage("Step 2$hashkey|WARNING - now a warning...");
            Thread.sleep(3000L);
            lp.statusMessage("Step 2$hashkey|Back to normal.");
            Thread.sleep(3000L);
            lp.statusMessage("Step 2$hashkey|INTERRUPTED.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

