/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.EventSetDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.HeadlessEventCollector;
import weka.gui.beans.ImageEvent;
import weka.gui.beans.ImageListener;
import weka.gui.beans.OffscreenChartRenderer;
import weka.gui.beans.PluginManager;
import weka.gui.beans.ThresholdDataEvent;
import weka.gui.beans.ThresholdDataListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.VisualizableErrorEvent;
import weka.gui.beans.VisualizableErrorListener;
import weka.gui.beans.WekaOffscreenChartRenderer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class ModelPerformanceChart
extends JPanel
implements ThresholdDataListener,
VisualizableErrorListener,
Visible,
UserRequestAcceptor,
EventConstraints,
Serializable,
BeanContextChild,
HeadlessEventCollector,
BeanCommon,
EnvironmentHandler {
    private static final long serialVersionUID = -4602034200071195924L;
    protected BeanVisual m_visual = new BeanVisual("ModelPerformanceChart", "weka/gui/beans/icons/ModelPerformanceChart.gif", "weka/gui/beans/icons/ModelPerformanceChart_animated.gif");
    protected transient PlotData2D m_masterPlot;
    protected transient List<Instances> m_offscreenPlotData;
    protected transient List<String> m_thresholdSeriesTitles;
    protected transient OffscreenChartRenderer m_offscreenRenderer;
    protected String m_offscreenRendererName = "Weka Chart Renderer";
    protected String m_xAxis = "";
    protected String m_yAxis = "";
    protected String m_additionalOptions = "";
    protected String m_width = "500";
    protected String m_height = "400";
    protected transient JFrame m_popupFrame;
    protected boolean m_framePoppedUp = false;
    protected List<EventObject> m_headlessEvents;
    protected transient boolean m_processingHeadlessEvents = false;
    protected ArrayList<ImageListener> m_imageListeners = new ArrayList();
    protected List<Object> m_listenees = new ArrayList<Object>();
    protected boolean m_design;
    protected transient BeanContext m_beanContext = null;
    private transient VisualizePanel m_visPanel;
    protected transient Environment m_env;
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);

    public ModelPerformanceChart() {
        this.useDefaultVisual();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!ge.isHeadless()) {
            this.appearanceFinal();
        } else {
            this.m_headlessEvents = new ArrayList<EventObject>();
        }
    }

    public String globalInfo() {
        return "Visualize performance charts (such as ROC).";
    }

    protected void appearanceDesign() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    protected void setUpFinal() {
        if (this.m_visPanel == null) {
            this.m_visPanel = new VisualizePanel();
        }
        this.add((Component)this.m_visPanel, "Center");
    }

    protected void setupOffscreenRenderer() {
        if (this.m_offscreenRenderer == null) {
            if (this.m_offscreenRendererName == null || this.m_offscreenRendererName.length() == 0) {
                this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                return;
            }
            if (this.m_offscreenRendererName.equalsIgnoreCase("weka chart renderer")) {
                this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
            } else {
                try {
                    Object r = PluginManager.getPluginInstance("weka.gui.beans.OffscreenChartRenderer", this.m_offscreenRendererName);
                    this.m_offscreenRenderer = r != null && r instanceof OffscreenChartRenderer ? (OffscreenChartRenderer)r : new WekaOffscreenChartRenderer();
                }
                catch (Exception ex) {
                    this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                }
            }
        }
    }

    @Override
    public synchronized void acceptDataSet(ThresholdDataEvent e) {
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.m_visPanel == null) {
                this.m_visPanel = new VisualizePanel();
            }
            if (this.m_masterPlot == null) {
                this.m_masterPlot = e.getDataSet();
            }
            try {
                if (!this.m_masterPlot.getPlotInstances().relationName().equals(e.getDataSet().getPlotInstances().relationName())) {
                    this.m_masterPlot = e.getDataSet();
                    this.m_visPanel.setMasterPlot(this.m_masterPlot);
                    this.m_visPanel.validate();
                    this.m_visPanel.repaint();
                } else {
                    this.m_visPanel.addPlot(e.getDataSet());
                    this.m_visPanel.validate();
                    this.m_visPanel.repaint();
                }
                this.m_visPanel.setXIndex(4);
                this.m_visPanel.setYIndex(5);
            }
            catch (Exception ex) {
                System.err.println("Problem setting up visualization (ModelPerformanceChart)");
                ex.printStackTrace();
            }
        } else {
            this.m_headlessEvents.add(e);
        }
        if (this.m_imageListeners.size() > 0 && !this.m_processingHeadlessEvents) {
            String[] optsParts;
            this.setupOffscreenRenderer();
            if (this.m_offscreenPlotData == null || !this.m_offscreenPlotData.get(0).relationName().equals(e.getDataSet().getPlotInstances().relationName())) {
                this.m_offscreenPlotData = new ArrayList<Instances>();
                this.m_thresholdSeriesTitles = new ArrayList<String>();
            }
            this.m_offscreenPlotData.add(e.getDataSet().getPlotInstances());
            this.m_thresholdSeriesTitles.add(e.getDataSet().getPlotName());
            ArrayList<String> options = new ArrayList<String>();
            String additional = "-color=/last";
            if (this.m_additionalOptions != null && this.m_additionalOptions.length() > 0) {
                additional = this.m_additionalOptions;
                try {
                    additional = this.m_env.substitute(additional);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            for (String p : optsParts = additional.split(",")) {
                options.add(p.trim());
            }
            String xAxis = "False Positive Rate";
            if (this.m_xAxis != null && this.m_xAxis.length() > 0) {
                xAxis = this.m_xAxis;
                try {
                    xAxis = this.m_env.substitute(xAxis);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            String yAxis = "True Positive Rate";
            if (this.m_yAxis != null && this.m_yAxis.length() > 0) {
                yAxis = this.m_yAxis;
                try {
                    yAxis = this.m_env.substitute(yAxis);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            String width = this.m_width;
            String height = this.m_height;
            int defWidth = 500;
            int defHeight = 400;
            try {
                width = this.m_env.substitute(width);
                height = this.m_env.substitute(height);
                defWidth = Integer.parseInt(width);
                defHeight = Integer.parseInt(height);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                ArrayList<Instances> series = new ArrayList<Instances>();
                for (int i = 0; i < this.m_offscreenPlotData.size(); ++i) {
                    Instances temp = new Instances(this.m_offscreenPlotData.get(i));
                    temp.setRelationName(this.m_thresholdSeriesTitles.get(i));
                    series.add(temp);
                }
                BufferedImage osi = this.m_offscreenRenderer.renderXYLineChart(defWidth, defHeight, series, xAxis, yAxis, options);
                ImageEvent ie = new ImageEvent(this, osi);
                this.notifyImageListeners(ie);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void acceptDataSet(VisualizableErrorEvent e) {
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.m_visPanel == null) {
                this.m_visPanel = new VisualizePanel();
            }
            this.m_masterPlot = e.getDataSet();
            try {
                this.m_visPanel.setMasterPlot(this.m_masterPlot);
            }
            catch (Exception ex) {
                System.err.println("Problem setting up visualization (ModelPerformanceChart)");
                ex.printStackTrace();
            }
            this.m_visPanel.validate();
            this.m_visPanel.repaint();
        } else {
            this.m_headlessEvents = new ArrayList<EventObject>();
            this.m_headlessEvents.add(e);
        }
        if (this.m_imageListeners.size() > 0 && !this.m_processingHeadlessEvents) {
            String[] optionsParts;
            Instances newInsts;
            FastVector<Attribute> atts;
            this.setupOffscreenRenderer();
            this.m_offscreenPlotData = new ArrayList<Instances>();
            Instances predictedI = e.getDataSet().getPlotInstances();
            if (predictedI.classAttribute().isNominal()) {
                int i;
                atts = new FastVector<Attribute>();
                for (int i2 = 0; i2 < predictedI.numAttributes(); ++i2) {
                    atts.add((Attribute)predictedI.attribute(i2).copy());
                }
                atts.add(new Attribute("@@size@@"));
                newInsts = new Instances(predictedI.relationName(), atts, predictedI.numInstances());
                newInsts.setClassIndex(predictedI.classIndex());
                for (int i3 = 0; i3 < predictedI.numInstances(); ++i3) {
                    double[] vals = new double[newInsts.numAttributes()];
                    for (int j = 0; j < predictedI.numAttributes(); ++j) {
                        vals[j] = predictedI.instance(i3).value(j);
                    }
                    vals[vals.length - 1] = 2.0;
                    DenseInstance ni = new DenseInstance(1.0, vals);
                    newInsts.add(ni);
                }
                Instances[] classes = new Instances[newInsts.numClasses()];
                for (int i4 = 0; i4 < newInsts.numClasses(); ++i4) {
                    classes[i4] = new Instances(newInsts, 0);
                    classes[i4].setRelationName(newInsts.classAttribute().value(i4));
                }
                Instances errors = new Instances(newInsts, 0);
                int actualClass = newInsts.classIndex();
                for (i = 0; i < newInsts.numInstances(); ++i) {
                    Instance current = newInsts.instance(i);
                    classes[(int)current.classValue()].add((Instance)current.copy());
                    if (current.value(actualClass) == current.value(actualClass - 1)) continue;
                    Instance toAdd = (Instance)current.copy();
                    toAdd.setValue(toAdd.numAttributes() - 1, 5.0);
                    double actualClassV = toAdd.value(actualClass);
                    double predictedClassV = toAdd.value(actualClass - 1);
                    toAdd.setValue(actualClass, predictedClassV);
                    toAdd.setValue(actualClass - 1, actualClassV);
                    errors.add(toAdd);
                }
                errors.setRelationName("Errors");
                this.m_offscreenPlotData.add(errors);
                for (i = 0; i < classes.length; ++i) {
                    this.m_offscreenPlotData.add(classes[i]);
                }
            } else {
                atts = new FastVector();
                for (int i = 0; i < predictedI.numAttributes(); ++i) {
                    atts.add((Attribute)predictedI.attribute(i).copy());
                }
                atts.add(new Attribute("@@size@@"));
                newInsts = new Instances(predictedI.relationName(), atts, predictedI.numInstances());
                int[] shapeSizes = e.getDataSet().getShapeSize();
                for (int i = 0; i < predictedI.numInstances(); ++i) {
                    double[] vals = new double[newInsts.numAttributes()];
                    for (int j = 0; j < predictedI.numAttributes(); ++j) {
                        vals[j] = predictedI.instance(i).value(j);
                    }
                    vals[vals.length - 1] = shapeSizes[i];
                    DenseInstance ni = new DenseInstance(1.0, vals);
                    newInsts.add(ni);
                }
                newInsts.setRelationName(predictedI.classAttribute().name());
                this.m_offscreenPlotData.add(newInsts);
            }
            ArrayList<String> options = new ArrayList<String>();
            String additional = "-color=" + predictedI.classAttribute().name() + ",-hasErrors";
            if (this.m_additionalOptions != null && this.m_additionalOptions.length() > 0) {
                additional = additional + "," + this.m_additionalOptions;
                try {
                    additional = this.m_env.substitute(additional);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            for (String p : optionsParts = additional.split(",")) {
                options.add(p.trim());
            }
            options.add("-shapeSize=@@size@@");
            String xAxis = this.m_xAxis;
            try {
                xAxis = this.m_env.substitute(xAxis);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String yAxis = this.m_yAxis;
            try {
                yAxis = this.m_env.substitute(yAxis);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String width = this.m_width;
            String height = this.m_height;
            int defWidth = 500;
            int defHeight = 400;
            try {
                width = this.m_env.substitute(width);
                height = this.m_env.substitute(height);
                defWidth = Integer.parseInt(width);
                defHeight = Integer.parseInt(height);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                BufferedImage osi = this.m_offscreenRenderer.renderXYScatterPlot(defWidth, defHeight, this.m_offscreenPlotData, xAxis, yAxis, options);
                ImageEvent ie = new ImageEvent(this, osi);
                this.notifyImageListeners(ie);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyImageListeners(ImageEvent te) {
        ArrayList l;
        ModelPerformanceChart modelPerformanceChart = this;
        synchronized (modelPerformanceChart) {
            l = (ArrayList)this.m_imageListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((ImageListener)l.get(i)).acceptImage(te);
            }
        }
    }

    @Override
    public List<EventObject> retrieveHeadlessEvents() {
        return this.m_headlessEvents;
    }

    @Override
    public void processHeadlessEvents(List<EventObject> headless) {
        if (!GraphicsEnvironment.isHeadless()) {
            this.m_processingHeadlessEvents = true;
            for (EventObject e : headless) {
                if (e instanceof ThresholdDataEvent) {
                    this.acceptDataSet((ThresholdDataEvent)e);
                    continue;
                }
                if (!(e instanceof VisualizableErrorEvent)) continue;
                this.acceptDataSet((VisualizableErrorEvent)e);
            }
        }
        this.m_processingHeadlessEvents = false;
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ModelPerformanceChart.gif", "weka/gui/beans/icons/ModelPerformanceChart_animated.gif");
    }

    @Override
    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_masterPlot != null) {
            newVector.addElement("Show chart");
            newVector.addElement("?Clear all plots");
        }
        return newVector.elements();
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bcSupport.addPropertyChangeListener(name, pcl);
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bcSupport.removePropertyChangeListener(name, pcl);
    }

    @Override
    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.addVetoableChangeListener(name, vcl);
    }

    @Override
    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.removeVetoableChangeListener(name, vcl);
    }

    @Override
    public void setBeanContext(BeanContext bc) {
        this.m_beanContext = bc;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!ge.isHeadless()) {
                this.appearanceFinal();
            }
        }
    }

    @Override
    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    @Override
    public void performRequest(String request) {
        block7: {
            if (request.compareTo("Show chart") == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        final JFrame jf = new JFrame("Model Performance Chart");
                        jf.setSize(800, 600);
                        jf.getContentPane().setLayout(new BorderLayout());
                        jf.getContentPane().add((Component)this.m_visPanel, "Center");
                        jf.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                jf.dispose();
                                ModelPerformanceChart.this.m_framePoppedUp = false;
                            }
                        });
                        jf.setVisible(true);
                        this.m_popupFrame = jf;
                        break block7;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else if (request.equals("Clear all plots")) {
                this.m_visPanel.removeAllPlots();
                this.m_visPanel.validate();
                this.m_visPanel.repaint();
                this.m_visPanel = null;
                this.m_masterPlot = null;
                this.m_offscreenPlotData = null;
            } else {
                throw new IllegalArgumentException(request + " not supported (Model Performance Chart)");
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("Usage: ModelPerformanceChart <dataset>");
                System.exit(1);
            }
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            Instances inst = new Instances(r);
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            ModelPerformanceChart as = new ModelPerformanceChart();
            PlotData2D pd = new PlotData2D(inst);
            pd.setPlotName(inst.relationName());
            ThresholdDataEvent roc = new ThresholdDataEvent(as, pd);
            as.acceptDataSet(roc);
            jf.getContentPane().add((Component)as, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    public synchronized void addImageListener(ImageListener cl) {
        this.m_imageListeners.add(cl);
    }

    public synchronized void removeImageListener(ImageListener cl) {
        this.m_imageListeners.remove(cl);
    }

    @Override
    public void setLog(Logger logger) {
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return eventName.equals("thresholdData") || eventName.equals("visualizableError");
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenees.add(source);
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        this.m_listenees.remove(source);
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        boolean ok = false;
        for (Object o : this.m_listenees) {
            if (!(o instanceof EventConstraints) || !((EventConstraints)o).eventGeneratable("thresholdData") && !((EventConstraints)o).eventGeneratable("visualizableError")) continue;
            ok = true;
            break;
        }
        return ok;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public void setOffscreenXAxis(String xAxis) {
        this.m_xAxis = xAxis;
    }

    public String getOffscreenXAxis() {
        return this.m_xAxis;
    }

    public void setOffscreenYAxis(String yAxis) {
        this.m_yAxis = yAxis;
    }

    public String getOffscreenYAxis() {
        return this.m_yAxis;
    }

    public void setOffscreenWidth(String width) {
        this.m_width = width;
    }

    public String getOffscreenWidth() {
        return this.m_width;
    }

    public void setOffscreenHeight(String height) {
        this.m_height = height;
    }

    public String getOffscreenHeight() {
        return this.m_height;
    }

    public void setOffscreenRendererName(String rendererName) {
        this.m_offscreenRendererName = rendererName;
        this.m_offscreenRenderer = null;
    }

    public String getOffscreenRendererName() {
        return this.m_offscreenRendererName;
    }

    public void setOffscreenAdditionalOpts(String additional) {
        this.m_additionalOptions = additional;
    }

    public String getOffscreenAdditionalOpts() {
        return this.m_additionalOptions;
    }
}

