/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.lazy.IBk;
import weka.classifiers.meta.FilteredClassifier;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RandomProjection;

public class RandomizableFilteredClassifier
extends FilteredClassifier
implements Randomizable {
    static final long serialVersionUID = -4523466618555717333L;
    protected int m_Seed = 1;

    @Override
    public String globalInfo() {
        return "A simple variant of the FilteredClassifier that implements the Randomizable interface, useful for building ensemble classifiers using the RandomCommittee meta learner. It requires that either the filter or the base learner implement the Randomizable interface.";
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.lazy.IBk";
    }

    @Override
    protected String defaultFilterString() {
        return "weka.filters.unsupervised.attribute.RandomProjection";
    }

    public RandomizableFilteredClassifier() {
        this.m_Classifier = new IBk();
        this.m_Filter = new RandomProjection();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tRandom number seed.\n\t(default 1)", "S", 1, "-S <num>"));
        newVector.addAll(Collections.list(super.listOptions()));
        if (this.getFilter() instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + ":"));
            newVector.addAll(Collections.list(this.getFilter().listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String seed = Utils.getOption('S', options);
        if (seed.length() != 0) {
            this.setSeed(Integer.parseInt(seed));
        } else {
            this.setSeed(1);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-S");
        options.add("" + this.getSeed());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    @Override
    public void setSeed(int seed) {
        this.m_Seed = seed;
    }

    @Override
    public int getSeed() {
        return this.m_Seed;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifiers have been set!");
        }
        if (!(this.m_Classifier instanceof Randomizable) && !(this.m_Filter instanceof Randomizable)) {
            throw new Exception("Either the classifier or the filter must implement the Randomizable interface.");
        }
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        if (data.numInstances() == 0) {
            throw new Exception("No training instances.");
        }
        try {
            Random r = data.getRandomNumberGenerator(this.m_Seed);
            if (this.m_Filter instanceof Randomizable) {
                ((Randomizable)((Object)this.m_Filter)).setSeed(r.nextInt());
            }
            this.m_Filter.setInputFormat(data);
            data = Filter.useFilter(data, this.m_Filter);
            this.getClassifier().getCapabilities().testWithFail(data);
            this.m_FilteredInstances = data.stringFreeStructure();
            if (this.m_Classifier instanceof Randomizable) {
                ((Randomizable)((Object)this.m_Classifier)).setSeed(r.nextInt());
            }
            this.m_Classifier.buildClassifier(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public String toString() {
        if (this.m_FilteredInstances == null) {
            return "RandomizableFilteredClassifier: No model built yet.";
        }
        String result = "RandomizableFilteredClassifier using " + this.getClassifierSpec() + " on data filtered through " + this.getFilterSpec() + "\n\nFiltered Header\n" + this.m_FilteredInstances.toString() + "\n\nClassifier Model\n" + this.m_Classifier.toString();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9117 $");
    }

    public static void main(String[] argv) {
        RandomizableFilteredClassifier.runClassifier(new RandomizableFilteredClassifier(), argv);
    }
}

