/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.JobEnvironment;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="GetDataFromResult", category="Flow", toolTipText="Output data stored in the job environment", iconPath="weka/gui/knowledgeflow/icons/GetDataFromResult.gif")
public class GetDataFromResult
extends BaseStep {
    private static final long serialVersionUID = 7447845310997458636L;

    @Override
    public void stepInit() throws WekaException {
    }

    @Override
    public void start() throws WekaException {
        if (this.getStepManager().numIncomingConnections() == 0 && this.getStepManager().getExecutionEnvironment().getEnvironmentVariables() instanceof JobEnvironment) {
            JobEnvironment jobEnvironment = (JobEnvironment)this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
            this.outputDataFromResult(jobEnvironment.getResultData());
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        this.outputDataFromResult((Map)data.getPayloadElement("env_results"));
    }

    protected void outputDataFromResult(Map<String, LinkedHashSet<Data>> results) throws WekaException {
        if (results != null && results.size() > 0) {
            this.getStepManager().processing();
            Set<String> outConns = this.getStepManager().getOutgoingConnections().keySet();
            for (String conn : outConns) {
                LinkedHashSet<Data> connData = results.get(conn);
                if (connData != null) {
                    for (Data d : connData) {
                        this.getStepManager().outputData(d);
                    }
                    continue;
                }
                this.getStepManager().logBasic("No results of type '" + conn + "' in job " + "environment");
            }
        } else {
            this.getStepManager().logBasic("No results to output from job environment");
        }
        this.getStepManager().finished();
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("jobSuccess");
        }
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return Arrays.asList("dataSet", "trainingSet", "testSet", "batchClassifier", "batchClusterer", "batchAssociator", "text", "image");
    }
}

