/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.Attribute;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.JobEnvironment;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="SetVariables", category="Flow", toolTipText="Assign default values for static variables, if not already set, and for dynamic variables. Static variables are guaranteed to be available to all other steps at initialization as the Knowledge Flow makes sure that SetVariables is invoked first first. Dynamic variables can have their values set using the values of attributes from incoming instances. Dynamic variables are *not* guaranteed to be available to other steps in the flow - instead, they are intended for use by a directly connected 'Job' step, which will execute a specified sub-flow for each 'variables' data object received.", iconPath="weka/gui/knowledgeflow/icons/SetVariables.gif")
public class SetVariables
extends BaseStep {
    public static final String SEP1 = "@@vv@@";
    public static final String SEP2 = "@v@v";
    public static final String SEP3 = "@a@a";
    private static final long serialVersionUID = 8042350408846800738L;
    protected String m_internalRep = "";
    protected String m_dynamicInternalRep = "";
    protected Map<String, String> m_varsToSet = new LinkedHashMap<String, String>();
    protected Map<String, List<String>> m_varsToSetFromIncomingInstances = new LinkedHashMap<String, List<String>>();
    protected boolean m_structureOK;
    protected boolean m_structureCheckComplete;
    protected boolean m_raiseErrorWhenValueMissing;

    @ProgrammaticProperty
    public void setVarsInternalRep(String rep) {
        this.m_internalRep = rep;
    }

    public String getVarsInternalRep() {
        return this.m_internalRep;
    }

    @ProgrammaticProperty
    public void setDynamicVarsInternalRep(String rep) {
        this.m_dynamicInternalRep = rep;
    }

    public String getDynamicVarsInternalRep() {
        return this.m_dynamicInternalRep;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_structureCheckComplete = false;
        this.m_structureOK = false;
        this.m_varsToSet = SetVariables.internalToMap(this.m_internalRep);
        this.m_varsToSetFromIncomingInstances = SetVariables.internalDynamicToMap(this.m_dynamicInternalRep);
        Environment currentEnv = this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
        if (currentEnv == null) {
            throw new WekaException("The execution environment doesn't seem to have any support for variables");
        }
        if (!(currentEnv instanceof JobEnvironment)) {
            currentEnv = new JobEnvironment(currentEnv);
            this.getStepManager().getExecutionEnvironment().setEnvironmentVariables(currentEnv);
        }
        for (Map.Entry<String, String> e : this.m_varsToSet.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (key == null || key.length() <= 0 || value == null || currentEnv.getVariableValue(key) != null) continue;
            this.getStepManager().logDetailed("Setting variable: " + key + " = " + value);
            currentEnv.addVariable(key, value);
        }
        if (this.getStepManager().numIncomingConnections() > 0 && this.m_varsToSetFromIncomingInstances.size() == 0) {
            this.getStepManager().logWarning("Incoming data detected, but no variables to set from incoming instances have been defined");
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (!this.m_structureCheckComplete) {
            this.m_structureCheckComplete = true;
            Instances structure = null;
            structure = data.getConnectionName().equals("instance") ? ((Instance)data.getPrimaryPayload()).dataset() : (data.getConnectionName().equals("environment") ? ((Instance)data.getPayloadElement("aux_instance")).dataset() : (Instances)data.getPrimaryPayload());
            this.checkStructure(structure);
        }
        this.getStepManager().processing();
        if (data.getConnectionName().equals("instance") || data.getConnectionName().equals("environment")) {
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
                return;
            }
            if (this.getStepManager().isStreamFinished(data)) {
                Data finished = new Data("environment");
                if (data.getConnectionName().equals("environment")) {
                    finished.setPayloadElement("env_variables", data.getPayloadElement("env_variables"));
                    finished.setPayloadElement("env_properties", data.getPayloadElement("env_properties"));
                }
                this.getStepManager().throughputFinished(finished);
                return;
            }
            Instance toProcess = (Instance)(data.getConnectionName().equals("instance") ? data.getPrimaryPayload() : data.getPayloadElement("aux_instance"));
            this.getStepManager().throughputUpdateStart();
            this.processInstance(toProcess, data.getConnectionName().equals("environment") ? data : null);
            this.getStepManager().throughputUpdateEnd();
        } else {
            Instances insts = (Instances)data.getPrimaryPayload();
            for (int i = 0; i < insts.numInstances() && !this.isStopRequested(); ++i) {
                this.processInstance(insts.instance(i), null);
                Data finished = new Data("environment");
                this.getStepManager().throughputFinished(finished);
            }
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
            }
        }
    }

    protected void processInstance(Instance inst, Data existingEnv) throws WekaException {
        Map existingVars;
        HashMap<String, String> vars = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> e : this.m_varsToSetFromIncomingInstances.entrySet()) {
            String attName = this.environmentSubstitute(e.getKey());
            Attribute current = inst.dataset().attribute(attName);
            int index = -1;
            if (current != null) {
                index = current.index();
            } else {
                try {
                    index = Integer.parseInt(attName);
                    --index;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (index == -1) continue;
            String varToSet = this.environmentSubstitute(e.getValue().get(0));
            String val = this.environmentSubstitute(e.getValue().get(1));
            if (inst.isMissing(index)) {
                if (this.m_raiseErrorWhenValueMissing) {
                    throw new WekaException("Value of attribute '" + inst.attribute(index).name() + "' was missing in current instance");
                }
            } else {
                val = inst.stringValue(index);
            }
            vars.put(varToSet, val);
        }
        Environment env = this.getStepManager().getExecutionEnvironment().getEnvironmentVariables();
        for (Map.Entry e : vars.entrySet()) {
            env.addVariable((String)e.getKey(), (String)e.getValue());
        }
        if (existingEnv != null && (existingVars = (Map)existingEnv.getPayloadElement("env_variables")) != null) {
            vars.putAll(existingVars);
        }
        Data output = new Data("environment");
        output.setPayloadElement("env_variables", vars);
        if (existingEnv != null) {
            output.setPayloadElement("env_properties", existingEnv.getPayloadElement("env_properties"));
        }
        output.setPayloadElement("aux_instance", inst);
        output.setPayloadElement("incremental_stream", true);
        this.getStepManager().outputData(output);
    }

    protected void checkStructure(Instances structure) {
        ArrayList<String> notFoundInIncoming = new ArrayList<String>();
        for (String attName : this.m_varsToSetFromIncomingInstances.keySet()) {
            if (structure.attribute(attName) == null) {
                notFoundInIncoming.add(attName);
                continue;
            }
            this.m_structureOK = true;
        }
        if (notFoundInIncoming.size() == this.m_varsToSetFromIncomingInstances.size()) {
            this.getStepManager().logWarning("None of the specified attributes appear to be in the incoming instance structure");
            return;
        }
        for (String s : notFoundInIncoming) {
            this.getStepManager().logWarning("Attribute '" + s + "' was not found in the " + "incoming instance structure");
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("dataSet", "trainingSet", "testSet", "instance", "environment");
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() != 0) {
            return Arrays.asList("environment");
        }
        return new ArrayList<String>();
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.SetVariablesStepEditorDialog";
    }

    public static Map<String, List<String>> internalDynamicToMap(String internalRep) {
        LinkedHashMap<String, List<String>> varsToSet = new LinkedHashMap<String, List<String>>();
        if (internalRep != null && internalRep.length() > 0) {
            String[] parts;
            for (String p : parts = internalRep.split(SEP1)) {
                String[] attVal = p.split(SEP3);
                if (attVal.length != 2) continue;
                String attName = attVal[0].trim();
                String[] varDefault = attVal[1].trim().split(SEP2);
                String varName = varDefault[0].trim();
                String defaultV = "";
                if (varDefault.length == 2) {
                    defaultV = varDefault[1].trim();
                }
                ArrayList<String> varAndDefL = new ArrayList<String>();
                varAndDefL.add(varName);
                varAndDefL.add(defaultV);
                varsToSet.put(attName, varAndDefL);
            }
        }
        return varsToSet;
    }

    public static Map<String, String> internalToMap(String internalRep) {
        LinkedHashMap<String, String> varsToSet = new LinkedHashMap<String, String>();
        if (internalRep != null && internalRep.length() > 0) {
            String[] parts;
            for (String p : parts = internalRep.split(SEP1)) {
                String[] keyVal = p.trim().split(SEP2);
                if (keyVal.length != 2) continue;
                varsToSet.put(keyVal[0].trim(), keyVal[1]);
            }
        }
        return varsToSet;
    }
}

