/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.decorator;

import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;

public final class DecoratorUtilities {
    private static final String TH_WITH = "th:with";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String HTML_ELEMENT_HTML = "html";
    public static final String HTML_ELEMENT_HEAD = "head";
    public static final String HTML_ELEMENT_TITLE = "title";
    public static final String HTML_ELEMENT_BODY = "body";

    private DecoratorUtilities() {
    }

    public static Element findElement(Element element, String name) {
        if (element.getOriginalName().equals(name)) {
            return element;
        }
        for (Element child : element.getElementChildren()) {
            Element result = DecoratorUtilities.findElement(child, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void pullAttributes(Element targetelement, Element sourceelement) {
        if (targetelement == null || sourceelement == null) {
            return;
        }
        for (Attribute contentattribute : sourceelement.getAttributeMap().values()) {
            String attributename = contentattribute.getOriginalName();
            if (attributename.equals(TH_WITH) && targetelement.hasAttribute(TH_WITH)) {
                targetelement.setAttribute(attributename, contentattribute.getValue() + "," + targetelement.getAttributeValue(TH_WITH));
                continue;
            }
            targetelement.setAttribute(contentattribute.getOriginalName(), contentattribute.getValue());
        }
    }

    public static void pullContent(Element targettelement, Element sourceelement) {
        targettelement.clearChildren();
        targettelement.addChild(sourceelement.cloneNode(null, false));
        targettelement.getParent().extractChild((Node)targettelement);
    }
}

