/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf;

import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;

public final class LayoutUtilities {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String HTML_ELEMENT_HTML = "html";
    public static final String HTML_ELEMENT_HEAD = "head";
    public static final String HTML_ELEMENT_TITLE = "title";
    public static final String HTML_ELEMENT_BODY = "body";

    private LayoutUtilities() {
    }

    public static boolean equalsAttributeName(Attribute attribute, String prefix, String name) {
        String attributename = attribute.getOriginalName();
        return attributename.equals(prefix + ":" + name) || attributename.equals("data-" + prefix + "-" + name);
    }

    public static String getAttributeValue(Element element, String prefix, String name) {
        String value = element.getAttributeValue(prefix + ":" + name);
        if (value == null) {
            value = element.getAttributeValue("data-" + prefix + "-" + name);
        }
        return value;
    }

    public static boolean hasAttribute(Element element, String prefix, String name) {
        return element.hasAttribute(prefix + ":" + name) || element.hasAttribute("data-" + prefix + "-" + name);
    }

    public static void pullAttributes(Element targetelement, Element sourceelement) {
        if (targetelement == null || sourceelement == null) {
            return;
        }
        for (Attribute sourceattribute : sourceelement.getAttributeMap().values()) {
            String targetwithvalue;
            if (LayoutUtilities.equalsAttributeName(sourceattribute, "th", "with") && (targetwithvalue = LayoutUtilities.getAttributeValue(targetelement, "th", "text")) != null) {
                targetelement.setAttribute("th:with", sourceattribute.getValue() + "," + targetwithvalue);
                continue;
            }
            targetelement.setAttribute(sourceattribute.getOriginalName(), sourceattribute.getValue());
        }
    }

    public static void pullContent(Element targettelement, Element sourceelement) {
        targettelement.clearChildren();
        targettelement.addChild(sourceelement.cloneNode(null, false));
        targettelement.getParent().extractChild((Node)targettelement);
    }

    public static void removeAttribute(Element element, String prefix, String name) {
        element.removeAttribute(prefix + ":" + name);
        element.removeAttribute("data-" + prefix + "-" + name);
    }
}

