/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.decorator;

import nz.net.ultraq.thymeleaf.LayoutUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;

public class TitlePatternProcessor
extends AbstractAttrProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TitlePatternProcessor.class);
    private static final String PARAM_TITLE_DECORATOR = "$DECORATOR_TITLE";
    private static final String PARAM_TITLE_CONTENT = "$CONTENT_TITLE";
    public static final String PROCESSOR_NAME_TITLEPATTERN = "title-pattern";
    public static final String DECORATOR_TITLE = "title-pattern::decorator-title";
    public static final String CONTENT_TITLE = "title-pattern::content-title";

    public TitlePatternProcessor() {
        super(PROCESSOR_NAME_TITLEPATTERN);
    }

    public int getPrecedence() {
        return 1;
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        if (!element.getNormalizedName().equals("title")) {
            logger.error("layout:title-pattern attribute should only appear in a <title> element");
            throw new IllegalArgumentException("layout:title-pattern attribute should only appear in a <title> element");
        }
        String titlepattern = "[[|" + element.getAttributeValue(attributeName) + "|]]";
        String decoratortitle = (String)arguments.getLocalVariable(DECORATOR_TITLE);
        String contenttitle = (String)arguments.getLocalVariable(CONTENT_TITLE);
        element.clearChildren();
        element.addChild((Node)new Text(titlepattern.replace(PARAM_TITLE_DECORATOR, decoratortitle != null ? decoratortitle : "").replace(PARAM_TITLE_CONTENT, contenttitle != null ? contenttitle : "")));
        element.removeAttribute(attributeName);
        if (!LayoutUtilities.hasAttribute(element, "th", "inline")) {
            element.setAttribute("th:inline", "text");
            element.setRecomputeProcessorsImmediately(true);
        }
        return ProcessorResult.OK;
    }
}

