/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.web.thymeleaf;

import java.util.HashMap;
import java.util.Map;
import nz.net.ultraq.web.thymeleaf.AbstractContentProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.Template;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.fragment.FragmentAndTarget;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.standard.fragment.StandardFragmentProcessor;

public class DecoratorProcessor
extends AbstractContentProcessor {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Logger logger = LoggerFactory.getLogger(DecoratorProcessor.class);
    static final String PROCESSOR_NAME_DECORATOR = "decorator";
    static final String PROCESSOR_NAME_DECORATOR_FULL = "layout:decorator";

    public DecoratorProcessor() {
        super(PROCESSOR_NAME_DECORATOR);
    }

    private void decorateBody(Element decoratorhtml, Element pagebody) {
        if (pagebody == null) {
            return;
        }
        Element decoratorbody = this.findElement(decoratorhtml, "body");
        if (decoratorbody == null) {
            decoratorhtml.addChild((Node)pagebody);
            decoratorhtml.addChild((Node)new Text(LINE_SEPARATOR));
            return;
        }
        DecoratorProcessor.mergeAttributes(pagebody, decoratorbody);
    }

    private void decorateHead(Element decoratorhtml, Element pagehead) {
        if (pagehead == null) {
            return;
        }
        Element decoratorhead = this.findElement(decoratorhtml, "head");
        if (decoratorhead == null) {
            decoratorhtml.insertChild(0, (Node)new Text(LINE_SEPARATOR));
            decoratorhtml.insertChild(1, (Node)pagehead);
            return;
        }
        Element pagetitle = this.findElement(pagehead, "title");
        if (pagetitle != null) {
            pagehead.removeChild((Node)pagetitle);
            Element decoratortitle = this.findElement(decoratorhead, "title");
            if (decoratortitle != null) {
                decoratorhead.insertBefore((Node)decoratortitle, (Node)pagetitle);
                decoratorhead.removeChild((Node)decoratortitle);
                if (decoratortitle.hasChildren()) {
                    HashMap<String, String> decoratortitlemap = new HashMap<String, String>();
                    decoratortitlemap.put("title-pattern::decorator-title", ((Text)decoratortitle.getFirstChild()).getContent());
                    pagetitle.setAllNodeLocalVariables(decoratortitlemap);
                    Attribute contenttitlepattern = (Attribute)pagetitle.getAttributeMap().get("layout:title-pattern");
                    DecoratorProcessor.mergeAttributes(decoratortitle, pagetitle);
                    if (contenttitlepattern != null) {
                        pagetitle.setAttribute("layout:title-pattern", contenttitlepattern.getValue());
                    }
                }
            } else {
                decoratorhead.insertChild(0, (Node)new Text(LINE_SEPARATOR));
                decoratorhead.insertChild(1, (Node)pagetitle);
            }
        }
        for (Node pageheadnode : pagehead.getChildren()) {
            decoratorhead.addChild(pageheadnode);
        }
        DecoratorProcessor.mergeAttributes(pagehead, decoratorhead);
    }

    private Element findElement(Element element, String name) {
        if (element.getOriginalName().equals(name)) {
            return element;
        }
        for (Element child : element.getElementChildren()) {
            Element result = this.findElement(child, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        Document decoratordocument;
        if (!(element.getParent() instanceof Document)) {
            logger.error("layout:decorator attribute must appear in the root element of your content page");
            throw new IllegalArgumentException("layout:decorator attribute must appear in the root element of your content page");
        }
        Document document = (Document)element.getParent();
        FragmentAndTarget fragmentandtarget = StandardFragmentProcessor.computeStandardFragmentSpec((Configuration)arguments.getConfiguration(), (IProcessingContext)arguments, (String)element.getAttributeValue(attributeName), null, null, (boolean)false);
        Template decorator = arguments.getTemplateRepository().getTemplate(new TemplateProcessingParameters(arguments.getConfiguration(), fragmentandtarget.getTemplateName(), arguments.getContext()));
        Element decoratorhtmlelement = decorator.getDocument().getFirstElementChild();
        if (decoratorhtmlelement == null || !decoratorhtmlelement.getOriginalName().equals("html")) {
            throw new IllegalArgumentException("Decorator page " + decorator.getTemplateName() + " must have an <html> root element");
        }
        element.removeAttribute(attributeName);
        this.decorateHead(decoratorhtmlelement, this.findElement(element, "head"));
        this.decorateBody(decoratorhtmlelement, this.findElement(element, "body"));
        Map<String, Object> fragments = this.findFragments(document.getElementChildren());
        if (!fragments.isEmpty()) {
            decoratorhtmlelement.setAllNodeLocalVariables(fragments);
        }
        if (element.getOriginalName().equals("html")) {
            DecoratorProcessor.mergeAttributes(element, decoratorhtmlelement);
        }
        if ((decoratordocument = (Document)decoratorhtmlelement.getParent()).hasDocType() && !document.hasDocType()) {
            document.setDocType(decoratordocument.getDocType());
        }
        boolean beforehtml = true;
        for (Node externalnode : decoratordocument.getChildren()) {
            if (externalnode.equals(decoratorhtmlelement)) {
                beforehtml = false;
                continue;
            }
            if (beforehtml) {
                document.insertBefore((Node)element, externalnode);
                continue;
            }
            document.insertAfter((Node)element, externalnode);
        }
        DecoratorProcessor.pullTargetContent(element, decoratorhtmlelement);
        return ProcessorResult.OK;
    }
}

