/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.web.thymeleaf;

import nz.net.ultraq.web.thymeleaf.AbstractProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.ProcessorResult;

public class FragmentProcessor
extends AbstractProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FragmentProcessor.class);
    static final String PROCESSOR_NAME_FRAGMENT = "fragment";
    static final String PROCESSOR_NAME_FRAGMENT_FULL = "layout:fragment";
    static final String FRAGMENT_NAME_PREFIX = "fragment-name::";

    public FragmentProcessor() {
        super(PROCESSOR_NAME_FRAGMENT);
    }

    public final int getPrecedence() {
        return 1;
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        if (element.getOriginalName().equals("title")) {
            logger.warn("You don't need to put the layout:fragment attribute into the <title> element - the decoration process will automatically override the <title> with the one in your content page, if present.");
        }
        String fragmentname = element.getAttributeValue(attributeName);
        Element pagefragment = (Element)arguments.getLocalVariable(FRAGMENT_NAME_PREFIX + fragmentname);
        element.removeAttribute(attributeName);
        if (pagefragment != null) {
            pagefragment.removeAttribute(attributeName);
            FragmentProcessor.mergeAttributes(element, pagefragment);
            FragmentProcessor.pullTargetContent(element, pagefragment);
        }
        return ProcessorResult.OK;
    }
}

