/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.web.thymeleaf;

import nz.net.ultraq.web.thymeleaf.AbstractProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.processor.ProcessorResult;

public class TitlePatternProcessor
extends AbstractProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TitlePatternProcessor.class);
    private static final String PARAM_TITLE_DECORATOR = "$DECORATOR_TITLE";
    private static final String PARAM_TITLE_CONTENT = "$CONTENT_TITLE";
    static final String PROCESSOR_NAME_TITLEPATTERN = "title-pattern";
    static final String PROCESSOR_NAME_TITLEPATTERN_FULL = "layout:title-pattern";
    static final String DECORATOR_TITLE_NAME = "title-pattern::decorator-title";

    public TitlePatternProcessor() {
        super(PROCESSOR_NAME_TITLEPATTERN);
    }

    public int getPrecedence() {
        return 1;
    }

    protected ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        if (!element.getNormalizedName().equals("title")) {
            logger.error("layout:title-pattern attribute should only appear in a <title> element");
            throw new IllegalArgumentException("layout:title-pattern attribute should only appear in a <title> element");
        }
        String titlepattern = element.getAttributeValue(attributeName);
        String decoratortitle = (String)arguments.getLocalVariable(DECORATOR_TITLE_NAME);
        String contenttitle = element.hasChildren() ? ((Text)element.getFirstChild()).getContent() : "";
        element.clearChildren();
        element.addChild((Node)new Text(titlepattern.replace(PARAM_TITLE_DECORATOR, decoratortitle).replace(PARAM_TITLE_CONTENT, contenttitle)));
        element.removeAttribute(attributeName);
        return ProcessorResult.OK;
    }
}

