/*
 * Decompiled with CFR 0.152.
 */
package org.amqphub.spring.boot.jms.autoconfigure;

import org.amqphub.spring.boot.jms.autoconfigure.AMQP10JMSConnectionFactoryCustomizer;
import org.amqphub.spring.boot.jms.autoconfigure.AMQP10JMSProperties;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.policy.JmsDefaultDeserializationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AMQP10JMSConnectionFactoryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AMQP10JMSConnectionFactoryFactory.class);
    private final AMQP10JMSProperties properties;
    private final ObjectProvider<AMQP10JMSConnectionFactoryCustomizer> factoryCustomizers;

    public AMQP10JMSConnectionFactoryFactory(AMQP10JMSProperties properties, ObjectProvider<AMQP10JMSConnectionFactoryCustomizer> factoryCustomizers) {
        Assert.notNull((Object)properties, (String)"Properties must not be null");
        this.properties = properties;
        this.factoryCustomizers = factoryCustomizers;
    }

    public JmsConnectionFactory createConnectionFactory(Class<JmsConnectionFactory> factoryClass) {
        try {
            JmsConnectionFactory factory = factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            factory.setRemoteURI(this.properties.getRemoteUrl());
            if (StringUtils.hasLength((String)this.properties.getUsername())) {
                factory.setUsername(this.properties.getUsername());
            }
            if (StringUtils.hasLength((String)this.properties.getPassword())) {
                factory.setPassword(this.properties.getPassword());
            }
            if (StringUtils.hasLength((String)this.properties.getClientId())) {
                factory.setClientID(this.properties.getClientId());
            }
            factory.setReceiveLocalOnly(this.properties.isReceiveLocalOnly());
            factory.setReceiveNoWaitLocalOnly(this.properties.isReceiveNoWaitLocalOnly());
            this.configureDeserializationPolicy(this.properties, factory);
            this.customizeFactoryConfiguration(factory);
            return factory;
        }
        catch (Exception ex) {
            LOG.error("Exception while createing the AMQP 1.0 JMS Connection Factory.", (Throwable)ex);
            throw new IllegalStateException("Failed to create the AMQP 1.0 JMS ConnectionFactory, make sure the client Jar is on the Classpath.", ex);
        }
    }

    private void configureDeserializationPolicy(AMQP10JMSProperties properties, JmsConnectionFactory factory) {
        JmsDefaultDeserializationPolicy deserializationPolicy = (JmsDefaultDeserializationPolicy)factory.getDeserializationPolicy();
        if (!ObjectUtils.isEmpty(properties.getDeserializationPolicy().getAllowList())) {
            deserializationPolicy.setAllowList(StringUtils.collectionToCommaDelimitedString(properties.getDeserializationPolicy().getAllowList()));
        }
        if (!ObjectUtils.isEmpty(properties.getDeserializationPolicy().getDenyList())) {
            deserializationPolicy.setDenyList(StringUtils.collectionToCommaDelimitedString(properties.getDeserializationPolicy().getDenyList()));
        }
    }

    private void customizeFactoryConfiguration(JmsConnectionFactory connectionFactory) {
        this.factoryCustomizers.orderedStream().forEach(customizer -> customizer.customize(connectionFactory));
    }
}

