/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.net;

import java.io.Serializable;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

class PGNetworkBase
extends PGobject
implements Serializable,
Cloneable {
    protected byte[] addr;
    protected int netmask;
    protected boolean embedded_ipv4 = false;
    protected String addrString = null;
    protected Integer hashCode = null;

    PGNetworkBase() {
    }

    protected boolean isIPv4Address(String host, boolean allowShortNotation) {
        if (host == null) {
            return false;
        }
        PGtokenizer t = new PGtokenizer(host, '.');
        int size = t.getSize();
        if (!allowShortNotation && size != 4 || allowShortNotation && (size < 1 || size > 4)) {
            return false;
        }
        byte[] address = new byte[4];
        try {
            for (int i = 0; i < size; ++i) {
                String chunk = t.getToken(i);
                if (chunk.length() == 0) {
                    return false;
                }
                int v = Integer.parseInt(chunk);
                if (v < 0 || v > 255) {
                    return false;
                }
                address[i] = (byte)(v & 0xFF);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.addr = address;
        this.hashCode = null;
        this.addrString = null;
        return true;
    }

    protected boolean isIPv6Address(String host) {
        if (host == null) {
            return false;
        }
        int index = host.indexOf(":");
        if (index == -1) {
            return false;
        }
        int shorthandIndex = host.indexOf("::", index);
        if (shorthandIndex != -1 && host.indexOf("::", shorthandIndex + 1) != -1) {
            return false;
        }
        if (host.endsWith(":") && !host.endsWith("::") || host.startsWith(":") && !host.startsWith("::")) {
            return false;
        }
        String head = host;
        String tail = "";
        if (shorthandIndex != -1) {
            head = host.substring(0, shorthandIndex);
            tail = host.substring(shorthandIndex + 2);
        }
        PGtokenizer headTokenizer = new PGtokenizer(head, ':');
        int headSize = headTokenizer.getSize();
        PGtokenizer tailTokenizer = new PGtokenizer(tail, ':');
        int tailSize = tailTokenizer.getSize();
        byte[] address = new byte[16];
        try {
            int k;
            int i = 0;
            for (k = 0; k < headSize; ++k) {
                String chunk = headTokenizer.getToken(k);
                if (chunk.length() <= 0) continue;
                if (i == 12 && chunk.indexOf(46) != -1) {
                    if (!this.isIPv4Address(chunk, false)) continue;
                    System.arraycopy(this.addr, 0, address, 12, 4);
                    this.addr = null;
                    this.embedded_ipv4 = true;
                    continue;
                }
                if (i > 14) {
                    return false;
                }
                int chunkValue = Integer.parseInt(chunk, 16);
                address[i++] = (byte)(chunkValue >> 8 & 0xFF);
                address[i++] = (byte)(chunkValue & 0xFF);
            }
            int j = 15;
            for (k = tailSize - 1; k >= 0; --k) {
                String chunk = tailTokenizer.getToken(k);
                if (chunk.length() <= 0) continue;
                if (j == 15 && chunk.indexOf(46) != -1) {
                    if (!this.isIPv4Address(chunk, false)) continue;
                    System.arraycopy(this.addr, 0, address, 12, 4);
                    this.addr = null;
                    this.embedded_ipv4 = true;
                    j = 11;
                    continue;
                }
                if (j < 1) {
                    return false;
                }
                int chunkValue = Integer.parseInt(chunk, 16);
                address[j--] = (byte)(chunkValue & 0xFF);
                address[j--] = (byte)(chunkValue >> 8 & 0xFF);
            }
            if (i - j > 1) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.addr = address;
        this.hashCode = null;
        this.addrString = null;
        return true;
    }

    protected String getHostPortion(String v) throws PSQLException {
        PGtokenizer t = new PGtokenizer(v, '/');
        int size = t.getSize();
        if (size != 1 && size != 2) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        return t.getToken(0);
    }

    protected int getNetmaskPortion(String v, int def) throws PSQLException {
        PGtokenizer t = new PGtokenizer(v, '/');
        int size = t.getSize();
        if (size != 1 && size != 2) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        int mask = def;
        if (size == 2) {
            try {
                mask = Integer.valueOf(t.getToken(1));
            }
            catch (NumberFormatException e) {
                throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
            }
        }
        return mask;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int hashValue = this.netmask | ~this.netmask << 8 | this.netmask << 16 << (~this.netmask << 24);
            for (int i = 0; i < this.addr.length; ++i) {
                hashValue ^= this.addr[i] << (i % 4 << 3);
            }
            this.hashCode = new Integer(hashValue);
        }
        return this.hashCode;
    }

    public String getValue() {
        if (this.addrString == null && this.addr != null) {
            StringBuffer s = new StringBuffer();
            boolean isIPv4 = this.addr.length == 4;
            boolean isIPv6 = this.addr.length == 16;
            for (int i = 0; i < this.addr.length; ++i) {
                if (isIPv4 || i >= 12 && this.embedded_ipv4) {
                    String digit = Integer.toString(this.addr[i] & 0xFF);
                    s.append(digit);
                    if ((!isIPv4 || i >= 3) && (!isIPv6 || i >= 15)) continue;
                    s.append(".");
                    continue;
                }
                String hexDigit = Integer.toHexString(this.addr[i] & 0xFF);
                if (hexDigit.length() == 1) {
                    s.append("0");
                }
                s.append(hexDigit);
                if (i % 2 != 1 || i == 15) continue;
                s.append(":");
            }
            if (this.addr.length == 16 && this.netmask < 128 || this.addr.length == 4 && this.netmask < 32) {
                s.append("/" + this.netmask);
            }
            this.addrString = s.toString();
        }
        return this.addrString;
    }

    public int getNetmask() {
        return this.netmask;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGNetworkBase) {
            PGNetworkBase inet = (PGNetworkBase)obj;
            if (inet.netmask == this.netmask && inet.addr.length == this.addr.length) {
                for (int i = 0; i < this.addr.length; ++i) {
                    if (inet.addr[i] == this.addr[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

