/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.net;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.net.PGNetworkBase;
import org.postgresql.util.GT;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGcidr
extends PGNetworkBase
implements Serializable,
Cloneable {
    public PGcidr(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGcidr() {
        this.setType("cidr");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGcidr) {
            return super.equals(obj);
        }
        return false;
    }

    public Object clone() {
        try {
            return new PGcidr(this.getValue());
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void setValue(String v) throws SQLException {
        if (v == null) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        String host = this.getHostPortion(v);
        if (this.isIPv6Address(host)) {
            this.netmask = this.getMinimalNetmask(v);
            if (this.netmask < 0 || this.netmask > 128) {
                this.netmask = 0;
                this.addr = null;
                throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
            }
        } else if (this.isIPv4Address(host, true)) {
            this.netmask = this.getMinimalNetmask(v);
            if (this.netmask < 0 || this.netmask > 32) {
                this.netmask = 0;
                this.addr = null;
                throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
            }
        } else {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        this.ensureHostBitsAreZero();
    }

    protected int getMinimalNetmask(String v) throws PSQLException {
        int mask;
        PGtokenizer t = new PGtokenizer(v, '/');
        int size = t.getSize();
        if (size != 1 && size != 2) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        if (size == 2) {
            try {
                mask = Integer.valueOf(t.getToken(1));
            }
            catch (NumberFormatException e) {
                throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
            }
        } else {
            mask = this.addr.length * 8;
            if (mask == 32) {
                int a = this.addr[0] & 0xFF;
                int b = this.addr[1] & 0xFF;
                int c = this.addr[2] & 0xFF;
                int d = this.addr[3] & 0xFF;
                if (a >= 0 && a <= 127) {
                    if (b == 0 && c == 0 && d == 0) {
                        mask = 8;
                    } else if (c == 0 && d == 0) {
                        mask = 16;
                    } else if (d == 0) {
                        mask = 24;
                    }
                } else if (a >= 128 && a <= 191) {
                    if (c == 0 && d == 0) {
                        mask = 16;
                    } else if (d == 0) {
                        mask = 24;
                    }
                } else if (a >= 192 && a <= 223 && d == 0) {
                    mask = 24;
                }
            }
        }
        return mask;
    }

    protected void ensureHostBitsAreZero() throws PSQLException {
        int network_bytes = this.netmask / 8;
        int network_bits = this.netmask % 8;
        if (network_bytes < this.addr.length && (this.addr[network_bytes] & 255 >> network_bits) != 0) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: host bits not all zero.", (Object[])new Object[]{this.type}), PSQLState.DATA_TYPE_MISMATCH);
        }
        for (int i = network_bytes + 1; i < this.addr.length; ++i) {
            if (this.addr[i] == 0) continue;
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: host bits not all zero.", (Object[])new Object[]{this.type}), PSQLState.DATA_TYPE_MISMATCH);
        }
    }
}

