/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.net;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.net.PGNetworkBase;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGinet
extends PGNetworkBase
implements Serializable,
Cloneable {
    public PGinet(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGinet() {
        this.setType("inet");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGinet) {
            return super.equals(obj);
        }
        return false;
    }

    public Object clone() {
        try {
            return new PGinet(this.getValue());
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void setValue(String v) throws SQLException {
        if (v == null) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        String host = this.getHostPortion(v);
        if (this.isIPv6Address(host)) {
            this.netmask = this.getNetmaskPortion(v, 128);
            if (this.netmask < 0 || this.netmask > 128) {
                this.netmask = 0;
                this.addr = null;
                throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
            }
        } else if (this.isIPv4Address(host, false)) {
            this.netmask = this.getNetmaskPortion(v, 32);
            if (this.netmask < 0 || this.netmask > 32) {
                this.netmask = 0;
                this.addr = null;
                throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
            }
        } else {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
    }
}

