/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.net;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGmacaddr
extends PGobject
implements Serializable,
Cloneable {
    byte[] macaddress = null;
    Integer hashCode = null;
    String strMac = null;

    public PGmacaddr(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGmacaddr() {
        this.setType("macaddr");
    }

    public byte[] getBytes() {
        return this.macaddress;
    }

    public void setValue(String v) throws SQLException {
        byte[] mac;
        if (v == null) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        if (v.startsWith(":") || v.startsWith(".") || v.startsWith("-") || v.endsWith(":") || v.endsWith(".") || v.endsWith("-")) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        String strippedMacAddr = null;
        PGtokenizer t = new PGtokenizer(v, ':');
        if (t.getSize() == 6 || t.getSize() == 2) {
            strippedMacAddr = this.strip(v, ':');
        }
        if (strippedMacAddr == null && ((t = new PGtokenizer(v, '-')).getSize() == 2 || t.getSize() == 6)) {
            strippedMacAddr = this.strip(v, '-');
        }
        if (strippedMacAddr == null && (t = new PGtokenizer(v, '.')).getSize() == 3) {
            strippedMacAddr = this.strip(v, '.');
        }
        if (strippedMacAddr == null) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        if (strippedMacAddr.length() != 12) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            mac = new byte[6];
            for (int i = 0; i < 6; ++i) {
                int twoi = i * 2;
                mac[i] = (byte)(Integer.valueOf(strippedMacAddr.substring(twoi, twoi + 2), 16) & 0xFF);
            }
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr((String)"Conversion to type {0} failed: {1}.", (Object[])new Object[]{this.type, v}), PSQLState.DATA_TYPE_MISMATCH);
        }
        this.macaddress = mac;
        this.hashCode = null;
        this.strMac = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGmacaddr) {
            PGmacaddr addr = (PGmacaddr)obj;
            byte[] thatBytes = addr.getBytes();
            if (this.macaddress == null || thatBytes == null) {
                return false;
            }
            if (thatBytes.length == this.macaddress.length && this.macaddress.length == 6) {
                for (int i = 0; i < 6; ++i) {
                    if (thatBytes[i] == this.macaddress[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int hashValue = this.macaddress[4] | this.macaddress[5] << 8 | this.macaddress[4] << 16 | this.macaddress[5] << 24;
            for (int i = 0; i < 4; ++i) {
                hashValue ^= this.macaddress[i] << (i << 3);
            }
            this.hashCode = new Integer(hashValue);
        }
        return this.hashCode;
    }

    public String getValue() {
        if (this.strMac == null) {
            StringBuffer val = new StringBuffer();
            for (int i = 0; i < this.macaddress.length; ++i) {
                if (i > 0) {
                    val.append(":");
                }
                val.append(Integer.toHexString(this.macaddress[i] & 0xFF));
            }
            this.strMac = val.toString();
        }
        return this.strMac;
    }

    private String strip(String s, char ch) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ch) continue;
            str.append(c);
        }
        return str.toString();
    }
}

