/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.collection_setter_injector;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.addon.collection_setter_injector.Messages;
import com.sun.tools.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.xjc.generator.bean.MethodWriter;
import com.sun.tools.xjc.generator.bean.field.UntypedListField;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.bind.api.impl.NameConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImpl
extends Plugin {
    private ClassOutlineImpl outline;
    private CPropertyInfo prop;
    private JType implType;
    private JType exposedType;
    private JCodeModel codeModel;
    private JFieldVar field;

    public String getOptionName() {
        return "Xcollection-setter-injector";
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList("http://jaxb.dev.java.net/plugin/collection-setter-injector");
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return nsUri.equals("http://jaxb.dev.java.net/plugin/collection-setter-injector") && localName.equals("collection");
    }

    public String getUsage() {
        return "  -Xcollection-setter-injector\t:  add setter method for collection-based properties";
    }

    public boolean run(Outline model, Options opt, ErrorHandler errorHandler) {
        FieldOutline[] fo = null;
        for (ClassOutline co : model.getClasses()) {
            fo = co.getDeclaredFields();
            if (null == fo || 0 >= fo.length) continue;
            for (int i = 0; i < fo.length; ++i) {
                if (!(fo[i] instanceof UntypedListField)) continue;
                this.declareMethod((ClassOutlineImpl)co, (UntypedListField)fo[i]);
            }
        }
        return true;
    }

    private void declareMethod(ClassOutlineImpl context, UntypedListField field) {
        MethodWriter writer = context.createMethodWriter();
        Map fields = null;
        NameConverter nc = context.parent().getModel().getNameConverter();
        this.outline = context;
        this.codeModel = context.parent().getCodeModel();
        this.prop = field.getPropertyInfo();
        fields = this.outline.implClass.fields();
        this.field = (JFieldVar)fields.get(field.getPropertyInfo().getName(false));
        JMethod $set = writer.declareMethod((JType)this.codeModel.VOID, "set" + this.prop.getName(true));
        JVar $value = writer.addParameter(this.field.type(), this.prop.getName(false));
        JBlock body = $set.body();
        body.assign((JAssignmentTarget)JExpr._this().ref((JVar)this.ref()), this.castToImplType((JExpression)$value));
        String javadoc = this.prop.javadoc;
        List<Object> possibleTypes = this.listPossibleTypes(this.prop);
        javadoc = this.prop.javadoc;
        if (javadoc.length() == 0) {
            javadoc = Messages.DEFAULT_SETTER_JAVADOC.format(nc.toVariableName(this.prop.getName(true)));
        }
        writer.javadoc().append((Object)javadoc);
        writer.javadoc().addParam($value).append((Object)"allowed object is\n").append(possibleTypes);
    }

    protected final List<Object> listPossibleTypes(CPropertyInfo prop) {
        ArrayList<Object> r = new ArrayList<Object>();
        for (CTypeInfo tt : prop.ref()) {
            JType t = ((NType)tt.getType()).toType((Outline)this.outline.parent(), Aspect.EXPOSED);
            if (t.isPrimitive() || t.isArray()) {
                r.add(t.fullName());
                continue;
            }
            r.add(t);
            r.add("\n");
        }
        return r;
    }

    protected JFieldVar ref() {
        return this.field;
    }

    protected final JExpression castToImplType(JExpression exp) {
        if (this.implType == this.exposedType) {
            return exp;
        }
        return JExpr.cast((JType)this.implType, (JExpression)exp);
    }
}

