/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.geo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.abdera.ext.geo.Coordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coordinates
implements Iterable<Coordinate>,
Serializable,
Cloneable,
Comparable<Coordinates> {
    private static final long serialVersionUID = 1640788106113796699L;
    protected List<Coordinate> coords = new ArrayList<Coordinate>();

    public Coordinates() {
    }

    public Coordinates(Coordinate ... coordinates) {
        for (Coordinate coord : coordinates) {
            this.add(coord);
        }
    }

    public Coordinates(Coordinates coordinates) {
        this.coords.addAll(coordinates.coords);
    }

    public Coordinates(String value) {
        Coordinates cs = Coordinates.parse(value);
        this.coords = cs.coords;
    }

    public synchronized Coordinate get(int n) {
        return this.coords.get(n);
    }

    public synchronized void add(Coordinates coordinates) {
        this.coords.addAll(coordinates.coords);
    }

    public synchronized void add(Coordinate coordinate) {
        this.coords.add(coordinate);
    }

    public synchronized void add(Coordinate ... coordinates) {
        for (Coordinate c : coordinates) {
            this.add(c);
        }
    }

    public synchronized void add(double latitude, double longitude) {
        this.coords.add(new Coordinate(latitude, longitude));
    }

    public synchronized void add(String value) {
        this.coords.add(new Coordinate(value));
    }

    public synchronized void remove(Coordinate coordinate) {
        if (this.coords.contains(coordinate)) {
            this.coords.remove(coordinate);
        }
    }

    public synchronized void remove(Coordinate ... coordinates) {
        for (Coordinate c : coordinates) {
            this.remove(c);
        }
    }

    public synchronized void remove(double latitude, double longitude) {
        this.remove(new Coordinate(latitude, longitude));
    }

    public synchronized void remove(String value) {
        this.remove(new Coordinate(value));
    }

    public synchronized boolean contains(double latitude, double longitude) {
        return this.contains(new Coordinate(latitude, longitude));
    }

    public synchronized boolean contains(String value) {
        return this.contains(new Coordinate(value));
    }

    public synchronized boolean contains(Coordinate coordinate) {
        return this.coords.contains(coordinate);
    }

    public synchronized boolean contains(Coordinate ... coordinates) {
        for (Coordinate c : coordinates) {
            if (this.coords.contains(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Coordinate> iterator() {
        return this.coords.iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Coordinate coord : this.coords) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(coord);
        }
        return buf.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.coords == null ? 0 : ((Object)this.coords).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinates other = (Coordinates)obj;
        return !(this.coords == null ? other.coords != null : !((Object)this.coords).equals(other.coords));
    }

    public static Coordinates parse(String value) {
        Coordinates cs = new Coordinates();
        try {
            String[] points = value.trim().split("\\s+");
            for (int n = 0; n < points.length; n += 2) {
                double lat = Double.parseDouble(points[n]);
                double lon = Double.parseDouble(points[n + 1]);
                Coordinate c = new Coordinate(lat, lon);
                cs.add(c);
            }
            return cs;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error parsing coordinate pairs", t);
        }
    }

    public int size() {
        return this.coords.size();
    }

    public void clear() {
        this.coords.clear();
    }

    public Coordinates clone() {
        try {
            return (Coordinates)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new Coordinates(this);
        }
    }

    public Coordinates sort() {
        return this.sort(false);
    }

    public Coordinates sort(boolean reverse) {
        Coordinates c = this.clone();
        if (reverse) {
            Collections.sort(c.coords, Collections.reverseOrder());
        } else {
            Collections.sort(c.coords);
        }
        return c;
    }

    @Override
    public int compareTo(Coordinates o) {
        if (o == null || this.equals(o)) {
            return 0;
        }
        if (this.size() < o.size()) {
            return -1;
        }
        if (o.size() < this.size()) {
            return 1;
        }
        for (int n = 0; n < this.size(); ++n) {
            Coordinate c2;
            Coordinate c1 = this.coords.get(n);
            int c = c1.compareTo(c2 = o.coords.get(n));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }
}

