/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Entry;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.methods.RequestEntity;

public class MultipartRelatedRequestEntity
implements RequestEntity {
    static final int BUFF_SIZE = 1024;
    static final byte[] buffer = new byte[1024];
    private final Entry entry;
    private final InputStream input;
    private final String contentType;
    private String boundary;

    public MultipartRelatedRequestEntity(Entry entry, InputStream input) {
        this(entry, input, null);
    }

    public MultipartRelatedRequestEntity(Entry entry, InputStream input, String contentType) {
        this(entry, input, contentType, null);
    }

    public MultipartRelatedRequestEntity(Entry entry, InputStream input, String contentType, String boundary) {
        this.input = input;
        this.entry = entry;
        this.contentType = contentType != null ? contentType : entry.getContentMimeType().toString();
        this.boundary = boundary != null ? boundary : String.valueOf(System.currentTimeMillis());
    }

    public void writeRequest(OutputStream arg0) throws IOException {
        DataOutputStream out = new DataOutputStream(arg0);
        out.writeBytes("--" + this.boundary + "\r\n");
        this.writeEntry(out);
        this.writeInput(out);
    }

    private void writeEntry(DataOutputStream out) throws IOException {
        out.writeBytes("content-type: " + MimeTypeHelper.getMimeType((Base)this.entry) + "\r\n\r\n");
        this.entry.writeTo((OutputStream)out);
        out.writeBytes("--" + this.boundary + "\r\n");
    }

    private void writeInput(DataOutputStream out) throws IOException {
        if (this.contentType == null) {
            throw new NullPointerException("media content type can't be null");
        }
        out.writeBytes("content-type: " + this.contentType + "\r\n");
        String contentId = this.entry.getContentSrc().toString();
        if (!contentId.matches("cid:.+")) {
            throw new IllegalArgumentException("entry content source is not a correct content-ID");
        }
        out.writeBytes("content-id: <" + contentId.substring(4) + ">\r\n\r\n");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while (this.input.read(buffer) != -1) {
            output.write(buffer);
        }
        Base64 base64 = new Base64();
        out.write(base64.encode(output.toByteArray()));
        out.writeBytes("\r\n--" + this.boundary + "--");
    }

    public long getContentLength() {
        return -1L;
    }

    public String getContentType() {
        return "Multipart/Related; boundary=\"" + this.boundary + "\";type=\"" + MimeTypeHelper.getMimeType((Base)this.entry) + "\"";
    }

    public boolean isRepeatable() {
        return true;
    }
}

