/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.gdata;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Formatter;
import org.apache.abdera.ext.gdata.GoogleLoginAuthCredentials;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class GoogleLoginAuthScheme
extends RFC2617Scheme
implements AuthScheme {
    private String service = null;

    public static void register(AbderaClient abderaClient, boolean exclusive) {
        AbderaClient.registerScheme((String)"GoogleLogin", GoogleLoginAuthScheme.class);
        if (exclusive) {
            abderaClient.setAuthenticationSchemePriority(new String[]{"GoogleLogin"});
        } else {
            abderaClient.setAuthenticationSchemeDefaults();
        }
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        super.processChallenge(challenge);
        this.service = this.getParameter("service");
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        String auth = null;
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usercreds = (UsernamePasswordCredentials)credentials;
            String id = usercreds.getUserName();
            String pwd = usercreds.getPassword();
            auth = this.getAuth(id, pwd);
        } else if (credentials instanceof GoogleLoginAuthCredentials) {
            GoogleLoginAuthCredentials gcreds = (GoogleLoginAuthCredentials)credentials;
            this.service = gcreds.getService();
            auth = gcreds.getAuth();
        } else {
            throw new AuthenticationException("Cannot use credentials for GoogleLogin authentication");
        }
        StringBuffer buf = new StringBuffer("GoogleLogin ");
        buf.append(auth);
        return buf.toString();
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        return this.authenticate(credentials, null);
    }

    public String getSchemeName() {
        return "GoogleLogin";
    }

    public boolean isComplete() {
        return true;
    }

    public boolean isConnectionBased() {
        return false;
    }

    protected String getAuth(String id, String pwd) {
        return this.getAuth(id, pwd, this.service);
    }

    protected String getAuth(String id, String pwd, String service) {
        try {
            AbderaClient abderaClient = new AbderaClient();
            Formatter f = new Formatter();
            f.format("Email=%s&Passwd=%s&service=%s&source=%s", URLEncoder.encode(id, "utf-8"), URLEncoder.encode(pwd, "utf-8"), service != null ? URLEncoder.encode(service, "utf-8") : "", URLEncoder.encode("Abdera", "utf-8"));
            StringRequestEntity stringreq = new StringRequestEntity(f.toString(), "application/x-www-form-urlencoded", "utf-8");
            String uri = "https://www.google.com/accounts/ClientLogin";
            RequestOptions options = abderaClient.getDefaultRequestOptions();
            options.setContentType("application/x-www-form-urlencoded");
            ClientResponse response = abderaClient.post(uri, (RequestEntity)stringreq, options);
            InputStream in = response.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int n = -1;
            while ((n = in.read()) != -1) {
                out.write(n);
            }
            out.flush();
            response.release();
            String auth = new String(out.toByteArray());
            return auth.split("\n")[2].replaceAll("Auth=", "auth=");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getGoogleLogin(String id, String pwd, String service) {
        String auth = new GoogleLoginAuthScheme().getAuth(id, pwd, service);
        StringBuffer buf = new StringBuffer("GoogleLogin ");
        buf.append(auth);
        return buf.toString();
    }
}

