/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.geo;

import org.apache.abdera.ext.geo.Coordinate;
import org.apache.abdera.ext.geo.Coordinates;
import org.apache.abdera.ext.geo.Multiple;
import org.apache.abdera.ext.geo.Point;

public class Box
extends Multiple {
    private static final String TWO_COORDINATES = "A box must have two coordinates";
    private static final long serialVersionUID = 3994252648307511152L;

    public Box() {
    }

    public Box(Multiple multiple) {
        super(multiple);
        if (this.coordinates.size() != 2) {
            throw new IllegalArgumentException(TWO_COORDINATES);
        }
    }

    public Box(Point lowerCorner, Point upperCorner) {
        super(lowerCorner, upperCorner);
    }

    public Box(Coordinate ... coordinates) {
        super(coordinates);
        if (this.coordinates.size() != 2) {
            throw new IllegalArgumentException(TWO_COORDINATES);
        }
    }

    public Box(Coordinates coordinates) {
        super(coordinates);
        if (this.coordinates.size() != 2) {
            throw new IllegalArgumentException(TWO_COORDINATES);
        }
    }

    public Box(String value) {
        super(value);
        if (this.coordinates.size() != 2) {
            throw new IllegalArgumentException(TWO_COORDINATES);
        }
    }

    public Box(Multiple ... multiples) {
        super(multiples);
        if (this.coordinates.size() != 2) {
            throw new IllegalArgumentException(TWO_COORDINATES);
        }
    }

    public Box(Point ... points) {
        super(points);
        if (this.coordinates.size() != 2) {
            throw new IllegalArgumentException(TWO_COORDINATES);
        }
    }

    public Box(double ... values) {
        super(values);
        if (this.coordinates.size() != 2) {
            throw new IllegalArgumentException(TWO_COORDINATES);
        }
    }

    public void setCoordinates(Coordinates coordinates) {
        super.setCoordinates(coordinates);
        if (this.coordinates.size() > 2) {
            throw new IllegalArgumentException(TWO_COORDINATES);
        }
    }

    public Coordinate getUpperCorner() {
        return this.coordinates.size() > 1 ? this.coordinates.get(1) : null;
    }

    public Coordinate getLowerCorner() {
        return this.coordinates.size() > 0 ? this.coordinates.get(0) : null;
    }
}

