/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.rss;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.rss.RssCategory;
import org.apache.abdera.ext.rss.RssConstants;
import org.apache.abdera.ext.rss.RssGuid;
import org.apache.abdera.ext.rss.RssImage;
import org.apache.abdera.ext.rss.RssItem;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.DateTime;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ElementWrapper;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.abdera.model.Generator;
import org.apache.abdera.model.IRIElement;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Text;
import org.apache.abdera.parser.stax.util.FOMElementIterator;
import org.apache.abdera.parser.stax.util.FOMHelper;
import org.apache.abdera.parser.stax.util.FOMList;
import org.apache.abdera.util.Constants;
import org.apache.abdera.xpath.XPath;
import org.apache.abdera.xpath.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssChannel
extends ExtensibleElementWrapper {
    public RssChannel(Element internal) {
        super(internal);
    }

    public RssChannel(Factory factory, QName qname) {
        super(factory, qname);
    }

    public void addEntry(Entry entry) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry addEntry() {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public List<Entry> getEntries() {
        QName qname = this.getQName();
        if (qname.getNamespaceURI().equals("http://purl.org/rss/1.0/") && qname.getLocalPart().equals("channel")) {
            ExtensibleElement se;
            ArrayList<Entry> entries = new ArrayList<Entry>();
            ExtensibleElement items = (ExtensibleElement)this.getExtension(RssConstants.QNAME_RDF_ITEMS);
            if (items != null && (se = (ExtensibleElement)items.getExtension(RssConstants.QNAME_RDF_SEQ)) != null) {
                List seq = se.getExtensions(RssConstants.QNAME_RDF_LI);
                for (Element el : seq) {
                    String res = el.getAttributeValue("resource");
                    if (res == null) continue;
                    String path = "//rss:item[@rdf:about='" + res + "']";
                    Element entryel = null;
                    try {
                        entryel = this.locate(path);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (entryel == null) continue;
                    entries.add(new RssItem(entryel));
                }
            }
            return entries;
        }
        return this.getExtensions(RssConstants.QNAME_ITEM);
    }

    public Entry getEntry(String id) {
        if (id == null) {
            return null;
        }
        List<Entry> l = this.getEntries();
        for (Entry e : l) {
            IRI eid = e.getId();
            if (eid == null || !eid.equals((Object)new IRI(id))) continue;
            return e;
        }
        return null;
    }

    public void insertEntry(Entry entry) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Entry insertEntry() {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void sortEntries(Comparator<Entry> comparator) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void sortEntriesByEdited(boolean new_first) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void sortEntriesByUpdated(boolean new_first) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void addAuthor(Person person) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Person addAuthor(String name) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Person addAuthor(String name, String email, String iri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void addCategory(Category category) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Category addCategory(String term) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Category addCategory(String scheme, String term, String label) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void addLink(Link link) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Link addLink(String href) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Link addLink(String href, String rel) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Link addLink(String href, String rel, String type, String title, String hreflang, long length) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Link getAlternateLink() {
        Link link = (Link)this.getExtension(RssConstants.QNAME_LINK);
        if (link == null) {
            link = (Link)this.getExtension(RssConstants.QNAME_RDF_LINK);
        }
        return link;
    }

    public Link getAlternateLink(String type, String hreflang) {
        return this.getAlternateLink();
    }

    public IRI getAlternateLinkResolvedHref() {
        Link link = this.getAlternateLink();
        return link != null ? link.getResolvedHref() : null;
    }

    public IRI getAlternateLinkResolvedHref(String type, String hreflang) {
        return this.getAlternateLinkResolvedHref();
    }

    public Person getAuthor() {
        Person person = (Person)this.getExtension(RssConstants.QNAME_MANAGINGEDITOR);
        if (person == null) {
            person = (Person)this.getExtension(RssConstants.QNAME_DC_CREATOR);
        }
        return person;
    }

    public List<Person> getAuthors() {
        List people = this.getExtensions(RssConstants.QNAME_MANAGINGEDITOR);
        if (people == null || people.size() == 0) {
            people = this.getExtensions(RssConstants.QNAME_DC_CREATOR);
        }
        return people;
    }

    public List<Person> getContributors() {
        List people = this.getExtensions(RssConstants.QNAME_DC_CONTRIBUTOR);
        return people;
    }

    public List<Category> getCategories() {
        List cats = this.getExtensions(RssConstants.QNAME_CATEGORY);
        if (cats == null || cats.size() == 0) {
            cats = this.getExtensions(RssConstants.QNAME_DC_SUBJECT);
        }
        return cats;
    }

    public List<Category> getCategories(String scheme) {
        return scheme != null ? new FOMList((Iterator)new FOMElementIterator(this.getInternal(), RssCategory.class, new QName("domain"), scheme, null)) : this.getCategories();
    }

    public Generator getGenerator() {
        return (Generator)this.getExtension(RssConstants.QNAME_GENERATOR);
    }

    public IRI getIcon() {
        IRIElement iri = this.getIconElement();
        return iri != null ? iri.getValue() : null;
    }

    public IRIElement getIconElement() {
        return this.getLogoElement();
    }

    public IRI getId() {
        IRIElement id = this.getIdElement();
        return id != null ? id.getValue() : null;
    }

    public IRIElement getIdElement() {
        return (IRIElement)this.getExtension(RssConstants.QNAME_DC_IDENTIFIER);
    }

    public Link getLink(String rel) {
        if (rel.equals("alternate") || rel.equals("http://www.iana.org/assignments/relation/alternate")) {
            RssGuid guid = (RssGuid)this.getIdElement();
            if (guid != null && guid.isPermalink()) {
                return guid;
            }
            return this.getAlternateLink();
        }
        List links = FOMHelper.getLinks((Element)this.getInternal(), (String)rel);
        return links != null && links.size() > 0 ? (Link)links.get(0) : null;
    }

    public IRI getLinkResolvedHref(String rel) {
        Link link = this.getLink(rel);
        return link != null ? link.getResolvedHref() : null;
    }

    public List<Link> getLinks() {
        return this.getExtensions(Constants.LINK);
    }

    public List<Link> getLinks(String rel) {
        return FOMHelper.getLinks((Element)this.getInternal(), (String)rel);
    }

    public List<Link> getLinks(String ... rel) {
        return FOMHelper.getLinks((Element)this.getInternal(), (String[])rel);
    }

    public IRI getLogo() {
        IRIElement iri = this.getLogoElement();
        return iri != null ? iri.getValue() : null;
    }

    public IRIElement getLogoElement() {
        Element image;
        IRIElement iri = (IRIElement)this.getExtension(RssConstants.QNAME_IMAGE);
        if (iri == null && (image = this.getExtension(RssConstants.QNAME_RDF_IMAGE)) != null) {
            String id = image.getAttributeValue(RssConstants.QNAME_RDF_RESOURCE);
            if (id != null) {
                String path = "//rss:image[@rdf:about='" + id + "']";
                Element res = null;
                try {
                    res = this.locate(path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (res != null) {
                    return new RssImage(res);
                }
            } else {
                return (IRIElement)image;
            }
        }
        return iri;
    }

    public String getRights() {
        Text text = this.getRightsElement();
        return text != null ? text.getValue() : null;
    }

    public Text getRightsElement() {
        Text text = (Text)this.getExtension(RssConstants.QNAME_COPYRIGHT);
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_DC_RIGHTS);
        }
        return text;
    }

    public Text.Type getRightsType() {
        Text text = this.getRightsElement();
        return text != null ? text.getTextType() : null;
    }

    public Link getSelfLink() {
        return this.getLink("self");
    }

    public IRI getSelfLinkResolvedHref() {
        Link link = this.getSelfLink();
        return link != null ? link.getResolvedHref() : null;
    }

    public String getSubtitle() {
        Text text = this.getSubtitleElement();
        return text != null ? text.getValue() : null;
    }

    public Text getSubtitleElement() {
        Text text = (Text)this.getExtension(RssConstants.QNAME_DESCRIPTION);
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_RDF_DESCRIPTION);
        }
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_DC_DESCRIPTION);
        }
        return text;
    }

    public Text.Type getSubtitleType() {
        Text text = this.getSubtitleElement();
        return text != null ? text.getTextType() : null;
    }

    public String getTitle() {
        Text text = this.getTitleElement();
        return text != null ? text.getValue() : null;
    }

    public Text getTitleElement() {
        Text text = (Text)this.getExtension(RssConstants.QNAME_TITLE);
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_RDF_TITLE);
        }
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_DC_TITLE);
        }
        return text;
    }

    public Text.Type getTitleType() {
        Text text = this.getTitleElement();
        return text != null ? text.getTextType() : null;
    }

    public Date getUpdated() {
        DateTime dt = this.getUpdatedElement();
        return dt != null ? dt.getDate() : null;
    }

    public DateTime getUpdatedElement() {
        DateTime dt = (DateTime)this.getExtension(RssConstants.QNAME_LASTBUILDDATE);
        if (dt == null) {
            dt = (DateTime)this.getExtension(RssConstants.QNAME_LASTBUILDDATE2);
        }
        if (dt == null) {
            dt = (DateTime)this.getExtension(RssConstants.QNAME_PUBDATE);
        }
        if (dt == null) {
            dt = (DateTime)this.getExtension(RssConstants.QNAME_PUBDATE2);
        }
        if (dt == null) {
            dt = (DateTime)this.getExtension(RssConstants.QNAME_DC_DATE);
        }
        return dt;
    }

    public String getUpdatedString() {
        DateTime dt = this.getUpdatedElement();
        return dt != null ? dt.getString() : null;
    }

    public Date getPublished() {
        DateTime dt = this.getPublishedElement();
        return dt != null ? dt.getDate() : null;
    }

    public DateTime getPublishedElement() {
        DateTime dt = (DateTime)this.getExtension(RssConstants.QNAME_PUBDATE);
        if (dt == null) {
            dt = (DateTime)this.getExtension(RssConstants.QNAME_PUBDATE2);
        }
        if (dt == null) {
            dt = (DateTime)this.getExtension(RssConstants.QNAME_DC_DATE);
        }
        return dt;
    }

    public String getPublishedString() {
        DateTime dt = this.getPublishedElement();
        return dt != null ? dt.getString() : null;
    }

    public IRIElement newId() {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void setGenerator(Generator generator) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Generator setGenerator(String iri, String version, String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public IRIElement setIcon(String iri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void setIconElement(IRIElement iri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public IRIElement setId(String id) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public IRIElement setId(String id, boolean normalize) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void setIdElement(IRIElement id) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public IRIElement setLogo(String iri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void setLogoElement(IRIElement iri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setRights(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setRights(String value, Text.Type type) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setRights(Div value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setRightsAsHtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setRightsAsXhtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void setRightsElement(Text text) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setSubtitle(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setSubtitle(String value, Text.Type type) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setSubtitle(Div value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setSubtitleAsHtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setSubtitleAsXhtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void setSubtitleElement(Text text) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setTitle(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setTitle(String value, Text.Type type) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setTitle(Div value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setTitleAsHtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public Text setTitleAsXhtml(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void setTitleElement(Text text) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public DateTime setUpdated(Date value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public DateTime setUpdated(String value) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public void setUpdatedElement(DateTime dateTime) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public String getLanguage() {
        String lang = this.getSimpleExtension(RssConstants.QNAME_LANGUAGE);
        if (lang == null) {
            lang = this.getSimpleExtension(RssConstants.QNAME_DC_LANGUAGE);
        }
        return lang;
    }

    public <T extends Element> T setLanguage(String language) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    private Element locate(String path) throws XPathException {
        Abdera abdera = this.getFactory().getAbdera();
        XPath xpath = abdera.getXPath();
        Map ns = xpath.getDefaultNamespaces();
        ns.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ns.put("rss", "http://purl.org/rss/1.0/");
        Element el = this.getDocument().getRoot();
        if (el instanceof ElementWrapper) {
            el = ((ElementWrapper)el).getInternal();
        }
        return (Element)xpath.selectSingleNode(path, (Base)el, ns);
    }
}

