/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.rss;

import javax.xml.namespace.QName;
import org.apache.abdera.ext.rss.RssConstants;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.abdera.model.IRIElement;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Text;

public class RssImage
extends ExtensibleElementWrapper
implements IRIElement {
    public RssImage(Element internal) {
        super(internal);
    }

    public RssImage(Factory factory, QName qname) {
        super(factory, qname);
    }

    public IRI getResolvedValue() {
        return this.getValue();
    }

    public IRI getValue() {
        String t;
        IRIElement iri = (IRIElement)this.getExtension(RssConstants.QNAME_URL);
        if (iri == null) {
            iri = (IRIElement)this.getExtension(RssConstants.QNAME_RDF_URL);
        }
        if (iri == null && (t = this.getAttributeValue(RssConstants.QNAME_RDF_ABOUT)) != null) {
            return new IRI(t);
        }
        return iri != null ? iri.getValue() : null;
    }

    public IRIElement setNormalizedValue(String iri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public IRIElement setValue(String iri) {
        throw new UnsupportedOperationException("Modifications are not allowed");
    }

    public String getTitle() {
        Text text = (Text)this.getExtension(RssConstants.QNAME_TITLE);
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_RDF_TITLE);
        }
        return text != null ? text.getValue() : null;
    }

    public String getDescription() {
        Text text = (Text)this.getExtension(RssConstants.QNAME_DESCRIPTION);
        if (text == null) {
            text = (Text)this.getExtension(RssConstants.QNAME_RDF_DESCRIPTION);
        }
        return text != null ? text.getValue() : null;
    }

    public IRI getLink() {
        Link link = (Link)this.getExtension(RssConstants.QNAME_LINK);
        if (link == null) {
            link = (Link)this.getExtension(RssConstants.QNAME_RDF_LINK);
        }
        return link != null ? link.getHref() : null;
    }

    public int getWidth() {
        String w = this.getSimpleExtension(RssConstants.QNAME_WIDTH);
        return w != null ? Integer.parseInt(w) : -1;
    }

    public int getHeight() {
        String w = this.getSimpleExtension(RssConstants.QNAME_HEIGHT);
        return w != null ? Integer.parseInt(w) : -1;
    }
}

