/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server;

import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.impl.DefaultProvider;
import org.apache.abdera.util.Discover;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManager {
    public static final String PROVIDER = "org.apache.abdera.protocol.server.Provider";
    private static final Log log = LogFactory.getLog(ServiceManager.class);
    private static ServiceManager INSTANCE = null;
    private static Abdera abdera = null;

    ServiceManager() {
    }

    public static synchronized ServiceManager getInstance() {
        if (INSTANCE == null) {
            log.debug((Object)Localizer.sprintf((String)"CREATING.NEW.INSTANCE", (Object[])new Object[]{"ServiceManager"}));
            INSTANCE = new ServiceManager();
        }
        return INSTANCE;
    }

    public static synchronized Abdera getAbdera() {
        if (abdera == null) {
            log.debug((Object)Localizer.sprintf((String)"CREATING.NEW.INSTANCE", (Object[])new Object[]{"Abdera"}));
            abdera = new Abdera();
        }
        return abdera;
    }

    public Provider newProvider(Map<String, String> properties) {
        Abdera abdera = ServiceManager.getAbdera();
        String instance = properties.get(PROVIDER);
        if (instance == null) {
            instance = DefaultProvider.class.getName();
        }
        log.debug((Object)Localizer.sprintf((String)"CREATING.NEW.INSTANCE", (Object[])new Object[]{"Provider"}));
        Provider provider = (Provider)Discover.locate((String)PROVIDER, (String)instance, (Object[])new Object[0]);
        log.debug((Object)Localizer.sprintf((String)"INITIALIZING.INSTANCE", (Object[])new Object[]{"Provider"}));
        provider.init(abdera, properties);
        return provider;
    }
}

