/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.junit;

import java.net.URI;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.junit.AbstractActiveMQClientResource;
import org.apache.activemq.junit.EmbeddedActiveMQBroker;

public abstract class AbstractActiveMQConsumerResource
extends AbstractActiveMQClientResource {
    MessageConsumer consumer;
    long defaultReceiveTimout = 50L;

    public AbstractActiveMQConsumerResource(String destinationName, ActiveMQConnectionFactory connectionFactory) {
        super(destinationName, connectionFactory);
    }

    public AbstractActiveMQConsumerResource(String destinationName, URI brokerURI) {
        super(destinationName, brokerURI);
    }

    public AbstractActiveMQConsumerResource(String destinationName, EmbeddedActiveMQBroker embeddedActiveMQBroker) {
        super(destinationName, embeddedActiveMQBroker);
    }

    public AbstractActiveMQConsumerResource(String destinationName, URI brokerURI, String userName, String password) {
        super(destinationName, brokerURI, userName, password);
    }

    public long getDefaultReceiveTimout() {
        return this.defaultReceiveTimout;
    }

    public void setDefaultReceiveTimout(long defaultReceiveTimout) {
        this.defaultReceiveTimout = defaultReceiveTimout;
    }

    @Override
    protected void createClient() throws JMSException {
        this.consumer = this.session.createConsumer((Destination)this.destination);
    }

    public BytesMessage receiveBytesMessage() throws JMSException {
        return (BytesMessage)this.receiveMessage();
    }

    public TextMessage receiveTextMessage() throws JMSException {
        return (TextMessage)this.receiveMessage();
    }

    public MapMessage receiveMapMessage() throws JMSException {
        return (MapMessage)this.receiveMessage();
    }

    public ObjectMessage receiveObjectMessage() throws JMSException {
        return (ObjectMessage)this.receiveMessage();
    }

    public BytesMessage receiveBytesMessage(long timeout) throws JMSException {
        return (BytesMessage)this.receiveMessage(timeout);
    }

    public TextMessage receiveTextMessage(long timeout) throws JMSException {
        return (TextMessage)this.receiveMessage(timeout);
    }

    public MapMessage receiveMapMessage(long timeout) throws JMSException {
        return (MapMessage)this.receiveMessage(timeout);
    }

    public ObjectMessage receiveObjectMessage(long timeout) throws JMSException {
        return (ObjectMessage)this.receiveMessage(timeout);
    }

    public Message receiveMessage() throws JMSException {
        return this.receiveMessage(this.defaultReceiveTimout);
    }

    public Message receiveMessage(long timeout) throws JMSException {
        Message message = null;
        message = timeout > 0L ? this.consumer.receive(timeout) : (timeout == 0L ? this.consumer.receiveNoWait() : this.consumer.receive());
        return message;
    }
}

