/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.as.issuer;

import java.security.MessageDigest;
import java.util.UUID;
import org.apache.amber.oauth2.as.issuer.ValueGenerator;
import org.apache.amber.oauth2.common.exception.OAuthSystemException;

public class MD5Generator
implements ValueGenerator {
    @Override
    public String generateValue() throws OAuthSystemException {
        return this.generateValue(UUID.randomUUID().toString());
    }

    @Override
    public String generateValue(String param) throws OAuthSystemException {
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(param.getBytes());
            byte[] messageDigest = algorithm.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new OAuthSystemException("OAuth Token cannot be generated.", (Throwable)e);
        }
    }
}

