/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.ext.dynamicreg.client.validators;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.amber.oauth2.client.response.OAuthClientResponse;
import org.apache.amber.oauth2.client.validator.OAuthClientValidator;
import org.apache.amber.oauth2.common.exception.OAuthProblemException;
import org.apache.amber.oauth2.common.utils.OAuthUtils;

public class RegistrationValidator
extends OAuthClientValidator {
    protected Map<String, String[]> optionalParams = new HashMap<String, String[]>();

    public RegistrationValidator() {
        this.requiredParams.put("client_id", new String[0]);
        this.optionalParams.put("issued_at", new String[]{"expires_in"});
    }

    private void validateOptionalParams(OAuthClientResponse response) throws OAuthProblemException {
        HashSet<String> missingParameters = new HashSet<String>();
        for (Map.Entry<String, String[]> requiredParam : this.optionalParams.entrySet()) {
            String[] dependentParams;
            String paramName = requiredParam.getKey();
            String val = response.getParam(paramName);
            if (OAuthUtils.isEmpty((String)val) || OAuthUtils.hasEmptyValues((String[])(dependentParams = requiredParam.getValue()))) continue;
            for (String dependentParam : dependentParams) {
                val = response.getParam(dependentParam);
                if (!OAuthUtils.isEmpty((String)val)) continue;
                missingParameters.add(dependentParam);
            }
        }
        if (!missingParameters.isEmpty()) {
            throw OAuthUtils.handleMissingParameters(missingParameters);
        }
    }

    public void validateParameters(OAuthClientResponse response) throws OAuthProblemException {
        super.validateParameters(response);
        this.validateOptionalParams(response);
    }
}

