/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.authentication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.archiva.redback.authentication.AuthenticationFailureCause;
import org.apache.archiva.redback.users.User;

public class AuthenticationResult
implements Serializable {
    private static final long serialVersionUID = 354054054054L;
    private boolean isAuthenticated;
    private String principal;
    private User user;
    private Exception exception;
    private List<AuthenticationFailureCause> authenticationFailureCauses;

    public AuthenticationResult() {
        this.isAuthenticated = false;
        this.principal = null;
        this.exception = null;
    }

    public AuthenticationResult(boolean authenticated, String principal, Exception exception) {
        this.isAuthenticated = authenticated;
        this.principal = principal;
        this.exception = exception;
    }

    public AuthenticationResult(boolean authenticated, String principal, Exception exception, List<AuthenticationFailureCause> authenticationFailureCauses) {
        this.isAuthenticated = authenticated;
        this.principal = principal;
        this.exception = exception;
        this.authenticationFailureCauses = authenticationFailureCauses;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Exception getException() {
        return this.exception;
    }

    public List<AuthenticationFailureCause> getAuthenticationFailureCauses() {
        if (this.authenticationFailureCauses == null) {
            this.authenticationFailureCauses = new ArrayList<AuthenticationFailureCause>();
        }
        return this.authenticationFailureCauses;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public AuthenticationResult user(User user) {
        this.setUser(user);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AuthenticationResult[");
        sb.append("principal=").append(this.principal);
        sb.append(",isAuthenticated=").append(Boolean.toString(this.isAuthenticated));
        sb.append(",exception=");
        if (this.exception != null) {
            sb.append(this.exception.getClass().getName());
            sb.append(" : ").append(this.exception.getMessage());
        } else {
            sb.append("<null>");
        }
        sb.append(']');
        return sb.toString();
    }
}

