/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.authentication.users;

import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.authentication.AbstractAuthenticator;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationFailureCause;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authentication.Authenticator;
import org.apache.archiva.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.policy.PasswordEncoder;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="authenticator#user-manager")
public class UserManagerAuthenticator
extends AbstractAuthenticator
implements Authenticator {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    @Named(value="userManager#default")
    private UserManager userManager;
    @Inject
    private UserSecurityPolicy securityPolicy;

    public String getId() {
        return "UserManagerAuthenticator";
    }

    @PostConstruct
    private void init() {
        this.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult authenticate(AuthenticationDataSource ds) throws AuthenticationException, AccountLockedException, MustChangePasswordException {
        boolean authenticationSuccess = false;
        String username = null;
        Throwable resultException = null;
        PasswordBasedAuthenticationDataSource source = (PasswordBasedAuthenticationDataSource)ds;
        ArrayList<AuthenticationFailureCause> authenticationFailureCauses = new ArrayList<AuthenticationFailureCause>();
        try {
            this.log.debug("Authenticate: {}", (Object)source);
            User user = this.userManager.findUser(source.getUsername());
            username = user.getUsername();
            if (user.isLocked()) {
                throw new AccountLockedException("Account " + source.getUsername() + " is locked.", user);
            }
            if (user.isPasswordChangeRequired() && source.isEnforcePasswordChange()) {
                throw new MustChangePasswordException("Password expired.", user);
            }
            PasswordEncoder encoder = this.securityPolicy.getPasswordEncoder();
            this.log.debug("PasswordEncoder: {}", (Object)encoder.getClass().getName());
            boolean isPasswordValid = encoder.isPasswordValid(user.getEncodedPassword(), source.getPassword());
            if (isPasswordValid) {
                this.log.debug("User {} provided a valid password", (Object)source.getUsername());
                try {
                    this.securityPolicy.extensionPasswordExpiration(user);
                }
                catch (MustChangePasswordException e) {
                    user.setPasswordChangeRequired(true);
                    throw e;
                }
                authenticationSuccess = true;
                if (user.getCountFailedLoginAttempts() > 0) {
                    user.setCountFailedLoginAttempts(0);
                    this.userManager.updateUser(user);
                }
                return new AuthenticationResult(true, source.getUsername(), null);
            }
            this.log.warn("Password is Invalid for user {}.", (Object)source.getUsername());
            authenticationFailureCauses.add(new AuthenticationFailureCause(1, "Password is Invalid for user " + source.getUsername() + "."));
            try {
                this.securityPolicy.extensionExcessiveLoginAttempts(user);
            }
            finally {
                this.userManager.updateUser(user);
            }
            return new AuthenticationResult(false, source.getUsername(), null, authenticationFailureCauses);
        }
        catch (UserNotFoundException e) {
            this.log.warn("Login for user {} failed. user not found.", (Object)source.getUsername());
            resultException = e;
            authenticationFailureCauses.add(new AuthenticationFailureCause(1, "Login for user " + source.getUsername() + " failed. user not found."));
        }
        catch (UserManagerException e) {
            this.log.warn("Login for user {} failed, message: {}", (Object)source.getUsername(), (Object)e.getMessage());
            resultException = e;
            authenticationFailureCauses.add(new AuthenticationFailureCause(2, "Login for user " + source.getUsername() + " failed, message: " + e.getMessage()));
        }
        return new AuthenticationResult(authenticationSuccess, username, (Exception)resultException, authenticationFailureCauses);
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public boolean supportsDataSource(AuthenticationDataSource source) {
        return source instanceof PasswordBasedAuthenticationDataSource;
    }

    public UserSecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setSecurityPolicy(UserSecurityPolicy securityPolicy) {
        this.securityPolicy = securityPolicy;
    }
}

