/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.checks.security;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.system.check.EnvironmentCheck;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="environmentCheck#locked-admin-check")
public class LockedAdminEnvironmentCheck
implements EnvironmentCheck {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="userManager#default")
    private UserManager userManager;
    @Inject
    @Named(value="rbacManager#default")
    private RBACManager rbacManager;
    private boolean checked = false;

    public void validateEnvironment(List<String> violations) {
        if (!this.checked && !this.userManager.isReadOnly()) {
            ArrayList<String> roles = new ArrayList<String>();
            roles.add("System Administrator");
            try {
                List systemAdminstrators = this.rbacManager.getUserAssignmentsForRoles(roles);
                for (UserAssignment userAssignment : systemAdminstrators) {
                    try {
                        User admin = this.userManager.findUser(userAssignment.getPrincipal());
                        if (!admin.isLocked()) continue;
                        this.log.info("Unlocking system administrator: {}", (Object)admin.getUsername());
                        admin.setLocked(false);
                        this.userManager.updateUser(admin);
                    }
                    catch (UserNotFoundException ne) {
                        this.log.warn("Dangling UserAssignment -> {}", (Object)userAssignment.getPrincipal());
                    }
                    catch (UserManagerException e) {
                        this.log.warn("fail to find user {}\u00a0for admin unlock check: {}", (Object)userAssignment.getPrincipal(), (Object)e.getMessage());
                    }
                }
            }
            catch (RbacManagerException e) {
                this.log.warn("Exception when checking for locked admin user: {}", (Object)e.getMessage(), (Object)e);
            }
            this.checked = true;
        }
    }
}

