/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.filter.authentication;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticationException;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpAuthenticator {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    protected SecuritySystem securitySystem;

    public AuthenticationResult authenticate(AuthenticationDataSource ds, HttpSession httpSession) throws AuthenticationException, AccountLockedException, MustChangePasswordException {
        try {
            SecuritySession securitySession = this.securitySystem.authenticate(ds);
            this.setSecuritySession(securitySession, httpSession);
            return securitySession.getAuthenticationResult().user(securitySession.getUser());
        }
        catch (AuthenticationException e) {
            String msg = "Unable to authenticate user: " + ds;
            this.log.info(msg, (Throwable)e);
            throw new HttpAuthenticationException(msg, e);
        }
        catch (UserNotFoundException e) {
            this.log.info("Login attempt against unknown user: {}", (Object)ds);
            throw new HttpAuthenticationException("User name or password invalid.");
        }
        catch (UserManagerException e) {
            this.log.info("UserManagerException: {}", (Object)e.getMessage());
            throw new HttpAuthenticationException(e.getMessage(), e);
        }
    }

    public void authenticate(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        try {
            AuthenticationResult result = this.getAuthenticationResult(request, response);
            if (result == null || !result.isAuthenticated()) {
                throw new HttpAuthenticationException("You are not authenticated.");
            }
        }
        catch (AccountLockedException e) {
            throw new HttpAuthenticationException("Your account is locked.", e);
        }
        catch (MustChangePasswordException e) {
            throw new HttpAuthenticationException("You must change your password.", e);
        }
    }

    public abstract void challenge(HttpServletRequest var1, HttpServletResponse var2, String var3, AuthenticationException var4) throws IOException;

    public abstract AuthenticationResult getAuthenticationResult(HttpServletRequest var1, HttpServletResponse var2) throws AuthenticationException, AccountLockedException, MustChangePasswordException;

    public User getSessionUser(HttpSession httpSession) {
        return (User)httpSession.getAttribute("SecuritySessionUser");
    }

    public boolean isAlreadyAuthenticated(HttpSession httpSession) {
        User user = this.getSessionUser(httpSession);
        return user != null && !user.isLocked() && !user.isPasswordChangeRequired();
    }

    public SecuritySession getSecuritySession(HttpSession httpSession) {
        SecuritySession securitySession = (SecuritySession)httpSession.getAttribute(SecuritySession.SESSION_KEY);
        if (securitySession != null) {
            return securitySession;
        }
        return (SecuritySession)httpSession.getAttribute("securitySession");
    }

    public void setSecuritySession(SecuritySession session, HttpSession httpSession) {
        httpSession.setAttribute(SecuritySession.SESSION_KEY, (Object)session);
        httpSession.setAttribute("SecuritySessionUser", (Object)session.getUser());
    }

    public void setSessionUser(User user, HttpSession httpSession) {
        httpSession.setAttribute(SecuritySession.SESSION_KEY, null);
        httpSession.setAttribute("SecuritySessionUser", (Object)user);
    }
}

