/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.filter.authentication.basic;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.integration.filter.authentication.AbstractHttpAuthenticationFilter;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticator;
import org.apache.archiva.redback.integration.filter.authentication.basic.HttpBasicAuthentication;

public class HttpBasicAuthenticationFilter
extends AbstractHttpAuthenticationFilter {
    private HttpAuthenticator httpAuthentication;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.httpAuthentication = (HttpAuthenticator)this.getApplicationContext().getBean("httpAuthenticator#basic", HttpAuthenticator.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            this.httpAuthentication.authenticate(httpRequest, httpResponse);
        }
        catch (AuthenticationException e) {
            HttpBasicAuthentication httpauthn = new HttpBasicAuthentication();
            ((HttpAuthenticator)httpauthn).challenge(httpRequest, httpResponse, this.getRealmName(), e);
            return;
        }
        chain.doFilter(request, response);
    }
}

