/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.filter.authorization;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.archiva.redback.authorization.AuthorizationException;
import org.apache.archiva.redback.integration.filter.SpringServletFilter;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthorizationFilter
extends SpringServletFilter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String permission;
    private String resource;
    private String accessDeniedLocation;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.permission = filterConfig.getInitParameter("permission");
        this.resource = filterConfig.getInitParameter("resource");
        this.accessDeniedLocation = filterConfig.getInitParameter("accessDeniedLocation");
        if (StringUtils.isEmpty((String)this.accessDeniedLocation)) {
            throw new ServletException("Missing parameter 'accessDeniedLocation' from " + SimpleAuthorizationFilter.class.getName() + " configuration.");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecuritySession securitySession = (SecuritySession)this.getApplicationContext().getBean("securitySession", SecuritySession.class);
        if (securitySession == null) {
            this.logger.warn("Security Session is null.");
            return;
        }
        SecuritySystem securitySystem = (SecuritySystem)this.getApplicationContext().getBean("securitySystem", SecuritySystem.class);
        boolean isAuthorized = false;
        try {
            isAuthorized = StringUtils.isEmpty((String)this.resource) ? securitySystem.isAuthorized(securitySession, this.permission) : securitySystem.isAuthorized(securitySession, this.permission, this.resource);
            if (isAuthorized) {
                chain.doFilter(request, response);
            } else {
                this.accessDenied(response);
            }
        }
        catch (AuthorizationException e) {
            this.accessDenied(response);
        }
    }

    protected void accessDenied(ServletResponse response) throws IOException {
        String newlocation = this.accessDeniedLocation;
        newlocation = newlocation.indexOf(63) == -1 ? newlocation + "?" : newlocation + "&";
        newlocation = newlocation + "resource=" + this.resource;
        ((HttpServletResponse)response).sendRedirect(newlocation);
    }
}

