/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.integration.util;

import java.util.Comparator;
import org.apache.archiva.redback.users.User;

public class UserComparator
implements Comparator<User> {
    private static final int UNKNOWN = -1;
    private static final int USERNAME = 1;
    private static final int FULLNAME = 2;
    private static final int EMAIL = 3;
    private static final int VALIDATED = 4;
    private static final int LOCKED = 5;
    private static final int PERMANENT = 6;
    private int propKey = -1;
    private boolean ascending;

    public UserComparator(String property, boolean ascending) {
        this.ascending = ascending;
        if ("username".equals(property)) {
            this.propKey = 1;
        } else if ("fullName".equals(property)) {
            this.propKey = 2;
        } else if ("email".equals(property)) {
            this.propKey = 3;
        } else if ("validated".equals(property)) {
            this.propKey = 4;
        } else if ("locked".equals(property)) {
            this.propKey = 5;
        } else if ("permanent".equals(property)) {
            this.propKey = 6;
        }
    }

    @Override
    public int compare(User user1, User user2) {
        if (user1 == null && user2 == null) {
            return 0;
        }
        if (user1 == null && user2 != null) {
            return -1;
        }
        if (user1 != null && user2 == null) {
            return 1;
        }
        return this.compareUsers(user1, user2) * (this.ascending ? 1 : -1);
    }

    private int compareUsers(User u1, User u2) {
        switch (this.propKey) {
            case 1: {
                return this.compareStrings(u1.getUsername(), u2.getUsername());
            }
            case 2: {
                return this.compareStrings(u1.getFullName(), u2.getFullName());
            }
            case 3: {
                return this.compareStrings(u1.getEmail(), u2.getEmail());
            }
            case 4: {
                return this.compareBooleans(u1.isValidated(), u2.isValidated());
            }
            case 5: {
                return this.compareBooleans(u1.isLocked(), u2.isLocked());
            }
            case 6: {
                return this.compareBooleans(u1.isPermanent(), u2.isPermanent());
            }
        }
        return 0;
    }

    private int compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null && s2 != null) {
            return -1;
        }
        if (s1 != null && s2 == null) {
            return 1;
        }
        return s1.toLowerCase().compareTo(s2.toLowerCase());
    }

    private int compareBooleans(boolean b1, boolean b2) {
        if (b1 == b2) {
            return 0;
        }
        return b1 ? 1 : -1;
    }
}

