/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.keys;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.apache.archiva.redback.keys.AuthenticationKey;
import org.apache.archiva.redback.keys.KeyManager;
import org.apache.archiva.redback.keys.KeyManagerException;
import org.apache.archiva.redback.keys.KeyNotFoundException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath*:/META-INF/spring-context.xml", "classpath*:/spring-context.xml"})
public class KeyManagerTestCase
extends TestCase {
    private KeyManager manager;

    public KeyManager getKeyManager() {
        return this.manager;
    }

    public void setKeyManager(KeyManager manager) {
        this.manager = manager;
    }

    private void assertSameDates(Date expected, Date actual) {
        if (expected == null && actual != null) {
            KeyManagerTestCase.fail((String)("Expected date is null, actual date [" + actual + "]."));
        }
        if (expected != null && actual == null) {
            KeyManagerTestCase.fail((String)("Expected date [" + expected + "], actual date is null."));
        }
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        KeyManagerTestCase.assertEquals((String)format.format(expected), (String)format.format(actual));
    }

    @Test
    public void testNormal() throws KeyNotFoundException, KeyManagerException {
        String principal = "foo";
        String purpose = "Testing";
        AuthenticationKey created = this.getKeyManager().createKey(principal, purpose, 15);
        KeyManagerTestCase.assertNotNull((Object)created);
        KeyManagerTestCase.assertNotNull((Object)created.getKey());
        KeyManagerTestCase.assertNotNull((Object)created.getDateCreated());
        KeyManagerTestCase.assertNotNull((Object)created.getDateExpires());
        KeyManagerTestCase.assertEquals((String)principal, (String)created.getForPrincipal());
        KeyManagerTestCase.assertEquals((String)purpose, (String)created.getPurpose());
        Date expectedCreated = created.getDateCreated();
        Date expectedExpires = created.getDateExpires();
        String expectedKey = created.getKey();
        AuthenticationKey found = this.getKeyManager().findKey(expectedKey);
        KeyManagerTestCase.assertEquals((String)expectedKey, (String)found.getKey());
        KeyManagerTestCase.assertEquals((String)principal, (String)found.getForPrincipal());
        KeyManagerTestCase.assertEquals((String)purpose, (String)found.getPurpose());
        this.assertSameDates(expectedCreated, found.getDateCreated());
        this.assertSameDates(expectedExpires, found.getDateExpires());
    }

    @Test
    public void testGetAllKeys() throws KeyManagerException {
        this.getKeyManager().eraseDatabase();
        AuthenticationKey created1 = this.getKeyManager().createKey("foo", "Testing", 15);
        AuthenticationKey created2 = this.getKeyManager().createKey("bar", "Something", 23);
        KeyManagerTestCase.assertNotNull((Object)created1);
        KeyManagerTestCase.assertNotNull((Object)created2);
        KeyManagerTestCase.assertEquals((String)"foo", (String)created1.getForPrincipal());
        KeyManagerTestCase.assertEquals((String)"Testing", (String)created1.getPurpose());
        KeyManagerTestCase.assertEquals((String)"bar", (String)created2.getForPrincipal());
        KeyManagerTestCase.assertEquals((String)"Something", (String)created2.getPurpose());
        List keys = this.getKeyManager().getAllKeys();
        Collections.sort(keys, new Comparator<AuthenticationKey>(){

            @Override
            public int compare(AuthenticationKey key1, AuthenticationKey key2) {
                return key2.getForPrincipal().compareTo(key1.getForPrincipal());
            }
        });
        AuthenticationKey found = (AuthenticationKey)keys.get(0);
        KeyManagerTestCase.assertEquals((String)created1.getKey(), (String)found.getKey());
        KeyManagerTestCase.assertEquals((String)"foo", (String)found.getForPrincipal());
        KeyManagerTestCase.assertEquals((String)"Testing", (String)found.getPurpose());
        this.assertSameDates(created1.getDateCreated(), found.getDateCreated());
        this.assertSameDates(created1.getDateExpires(), found.getDateExpires());
        found = (AuthenticationKey)keys.get(1);
        KeyManagerTestCase.assertEquals((String)created2.getKey(), (String)found.getKey());
        KeyManagerTestCase.assertEquals((String)"bar", (String)found.getForPrincipal());
        KeyManagerTestCase.assertEquals((String)"Something", (String)found.getPurpose());
        this.assertSameDates(created2.getDateCreated(), found.getDateCreated());
        this.assertSameDates(created2.getDateExpires(), found.getDateExpires());
    }

    @Test
    public void testNotThere() throws KeyManagerException {
        String principal = "foo";
        String purpose = "Testing";
        AuthenticationKey created = this.getKeyManager().createKey(principal, purpose, 15);
        KeyManagerTestCase.assertNotNull((Object)created);
        KeyManagerTestCase.assertNotNull((Object)created.getKey());
        KeyManagerTestCase.assertNotNull((Object)created.getDateCreated());
        KeyManagerTestCase.assertNotNull((Object)created.getDateExpires());
        KeyManagerTestCase.assertEquals((String)principal, (String)created.getForPrincipal());
        KeyManagerTestCase.assertEquals((String)purpose, (String)created.getPurpose());
        try {
            this.getKeyManager().findKey("deadbeefkey");
            KeyManagerTestCase.fail((String)"Invalid Key should not have been found.");
        }
        catch (KeyNotFoundException e) {
            // empty catch block
        }
    }

    @Test
    public void testExpired() throws KeyManagerException, InterruptedException {
        String principal = "foo";
        String purpose = "Testing";
        AuthenticationKey created = this.getKeyManager().createKey(principal, purpose, 0);
        KeyManagerTestCase.assertNotNull((Object)created);
        KeyManagerTestCase.assertNotNull((Object)created.getKey());
        KeyManagerTestCase.assertNotNull((Object)created.getDateCreated());
        KeyManagerTestCase.assertNotNull((Object)created.getDateExpires());
        KeyManagerTestCase.assertEquals((String)principal, (String)created.getForPrincipal());
        KeyManagerTestCase.assertEquals((String)purpose, (String)created.getPurpose());
        String expectedKey = created.getKey();
        try {
            Thread.sleep(500L);
            this.getKeyManager().findKey(expectedKey);
            KeyManagerTestCase.fail((String)"Expired Key should not have been found.");
        }
        catch (KeyNotFoundException e) {
            // empty catch block
        }
    }

    @Test
    public void testPermanent() throws KeyManagerException {
        String principal = "foo";
        String purpose = "Testing";
        AuthenticationKey created = this.getKeyManager().createKey(principal, purpose, -1);
        KeyManagerTestCase.assertNotNull((Object)created);
        KeyManagerTestCase.assertNotNull((Object)created.getKey());
        KeyManagerTestCase.assertNotNull((Object)created.getDateCreated());
        KeyManagerTestCase.assertNull((Object)created.getDateExpires());
        KeyManagerTestCase.assertEquals((String)principal, (String)created.getForPrincipal());
        KeyManagerTestCase.assertEquals((String)purpose, (String)created.getPurpose());
        Date expectedCreated = created.getDateCreated();
        String expectedKey = created.getKey();
        AuthenticationKey found = this.getKeyManager().findKey(expectedKey);
        KeyManagerTestCase.assertEquals((String)expectedKey, (String)found.getKey());
        KeyManagerTestCase.assertEquals((String)principal, (String)found.getForPrincipal());
        KeyManagerTestCase.assertEquals((String)purpose, (String)found.getPurpose());
        this.assertSameDates(expectedCreated, found.getDateCreated());
        KeyManagerTestCase.assertNull((Object)found.getDateExpires());
    }
}

