/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.policy.rules;

import javax.annotation.PostConstruct;
import org.apache.archiva.redback.policy.PasswordRuleViolations;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.policy.rules.AbstractPasswordRule;
import org.apache.archiva.redback.users.User;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#character-length")
public class CharacterLengthPasswordRule
extends AbstractPasswordRule {
    public static final int DEFAULT_CHARACTER_LENGTH_MAX = 8;
    private int minimumCharacters;
    private int maximumCharacters;

    public int getMaximumCharacters() {
        return this.maximumCharacters;
    }

    public int getMinimumCharacters() {
        return this.minimumCharacters;
    }

    public void setMaximumCharacters(int maximumCharacters) {
        this.maximumCharacters = maximumCharacters;
    }

    public void setMinimumCharacters(int minimumCharacters) {
        this.minimumCharacters = minimumCharacters;
    }

    @Override
    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
    }

    @Override
    public void testPassword(PasswordRuleViolations violations, User user) {
        String password;
        if (this.minimumCharacters > this.maximumCharacters) {
            violations.addViolation("user.password.violation.length.misconfigured", new String[]{String.valueOf(this.minimumCharacters), String.valueOf(this.maximumCharacters)});
        }
        if (StringUtils.isEmpty((String)(password = user.getPassword())) || password.length() < this.minimumCharacters || password.length() > this.maximumCharacters) {
            violations.addViolation("user.password.violation.length", new String[]{String.valueOf(this.minimumCharacters), String.valueOf(this.maximumCharacters)});
        }
    }

    @Override
    @PostConstruct
    public void initialize() {
        this.enabled = this.config.getBoolean("security.policy.password.rule.characterlength.enabled");
        this.minimumCharacters = this.config.getInt("security.policy.password.rule.characterlength.minimum");
        this.maximumCharacters = this.config.getInt("security.policy.password.rule.characterlength.maximum");
    }
}

