// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.7,
// any modifications will be overwritten.
// ==============================================================

package org.apache.archiva.redback.rbac.jdo.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.*;
import org.apache.archiva.redback.rbac.jdo.JdoOperation;
import org.apache.archiva.redback.rbac.jdo.JdoPermission;
import org.apache.archiva.redback.rbac.jdo.JdoResource;
import org.apache.archiva.redback.rbac.jdo.JdoRole;
import org.apache.archiva.redback.rbac.jdo.JdoUserAssignment;
import org.apache.archiva.redback.rbac.jdo.RbacDatabase;

/**
 * Class RbacJdoModelStaxReader.
 * 
 * @version $Revision$ $Date$
 */
public class RbacJdoModelStaxReader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field jdoPermissionReferences.
     */
    private java.util.Map jdoPermissionReferences;

    /**
     * Field jdoPermissionInstances.
     */
    private java.util.Map jdoPermissionInstances;

    /**
     * Field jdoOperationReferences.
     */
    private java.util.Map jdoOperationReferences;

    /**
     * Field jdoResourceReferences.
     */
    private java.util.Map jdoResourceReferences;

    /**
     * Field jdoOperationInstances.
     */
    private java.util.Map jdoOperationInstances;

    /**
     * Field jdoResourceInstances.
     */
    private java.util.Map jdoResourceInstances;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method read.
     * 
     * @param reader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    public RbacDatabase read( Reader reader, boolean strict )
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );

        return read( xmlStreamReader, strict );
    } //-- RbacDatabase read( Reader, boolean )

    /**
     * Method read.
     * 
     * @param reader
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    public RbacDatabase read( Reader reader )
        throws IOException, XMLStreamException
    {
        return read( reader, true );
    } //-- RbacDatabase read( Reader )

    /**
     * Method read.
     * 
     * @param stream
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    public RbacDatabase read( InputStream stream, boolean strict )
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( stream );

        return read( xmlStreamReader, strict );
    } //-- RbacDatabase read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param stream
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    public RbacDatabase read( InputStream stream )
        throws IOException, XMLStreamException
    {
        return read( stream, true );
    } //-- RbacDatabase read( InputStream )

    /**
     * Method read.
     * 
     * @param filePath
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    public RbacDatabase read( String filePath, boolean strict )
        throws IOException, XMLStreamException
    {
        java.io.File file = new java.io.File( filePath );
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( file.toURI().toURL().toExternalForm(), new FileInputStream( file ) );

        return read( xmlStreamReader, strict );
    } //-- RbacDatabase read( String, boolean )

    /**
     * Method read.
     * 
     * @param filePath
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    public RbacDatabase read( String filePath )
        throws IOException, XMLStreamException
    {
        return read( filePath, true );
    } //-- RbacDatabase read( String )

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param xmlStreamReader
     * @param parsed
     * @param alias
     * @param tagName
     * @throws XMLStreamException
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XMLStreamReader xmlStreamReader, String tagName, String alias, java.util.Set parsed )
        throws XMLStreamException
    {
        if ( !( xmlStreamReader.getLocalName().equals( tagName ) || xmlStreamReader.getLocalName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XMLStreamException( "Duplicated tag: '" + tagName + "'", xmlStreamReader.getLocation() );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XMLStreamReader, String, String, java.util.Set )

    /**
     * Method checkUnknownElement.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws XMLStreamException
     */
    private void checkUnknownElement( XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( strict )
        {
            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
        }
        int unrecognizedTagCount = 1;
        while( unrecognizedTagCount != 0 )
        {
            xmlStreamReader.next();
            if ( xmlStreamReader.getEventType() == XMLStreamConstants.START_ELEMENT )
            {
                unrecognizedTagCount++;
            }
            else if ( xmlStreamReader.getEventType() == XMLStreamConstants.END_ELEMENT )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XMLStreamReader, boolean )

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XMLStreamReader )

    /**
     * Method getByteValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a byte but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XMLStreamReader )

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param xmlStreamReader
     * @param dateFormat
     * @param attribute
     * @throws XMLStreamException
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XMLStreamException( e.getMessage(), xmlStreamReader.getLocation(), e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XMLStreamException( e.getMessage(), xmlStreamReader.getLocation(), e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XMLStreamReader )

    /**
     * Method getDefaultValue.
     * 
     * @param s
     * @param v
     * @return String
     */
    private String getDefaultValue( String s, String v )
    {
        if ( s == null )
        {
            s = v;
        }
        return s;
    } //-- String getDefaultValue( String, String )

    /**
     * Method getDoubleValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return float
     */
    private float getFloatValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return long
     */
    private long getLongValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XMLStreamException( "Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation() );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     * @throws XMLStreamException
     * @return short
     */
    private short getShortValue( String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict )
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XMLStreamReader, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method nextTag.
     * 
     * @param xmlStreamReader
     * @throws XMLStreamException
     * @return int
     */
    private int nextTag( XMLStreamReader xmlStreamReader )
        throws XMLStreamException
    {
        while ( true )
        {
            int eventType = xmlStreamReader.next();
            switch ( eventType )
            {
                case XMLStreamConstants.CHARACTERS:
                case XMLStreamConstants.CDATA:
                case XMLStreamConstants.SPACE:
                case XMLStreamConstants.PROCESSING_INSTRUCTION:
                case XMLStreamConstants.COMMENT:
                    break;
                case XMLStreamConstants.START_ELEMENT:
                case XMLStreamConstants.END_ELEMENT:
                    return eventType;
                default:
                    throw new XMLStreamException( "expected start or end tag", xmlStreamReader.getLocation() );
            }
        }
    } //-- int nextTag( XMLStreamReader )

    /**
     * Method parseJdoOperation.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoOperation
     */
    private JdoOperation parseJdoOperation( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        JdoOperation jdoOperation = new JdoOperation();
        java.util.Set parsed = new java.util.HashSet();
        if ( jdoOperationInstances == null )
        {
            jdoOperationInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            jdoOperationInstances.put( v, jdoOperation );
        }
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "name", null, parsed ) )
            {
                jdoOperation.setName( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "description", null, parsed ) )
            {
                jdoOperation.setDescription( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "permanent", null, parsed ) )
            {
                jdoOperation.setPermanent( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "permanent", xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "resourceRequired", null, parsed ) )
            {
                jdoOperation.setResourceRequired( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "resourceRequired", xmlStreamReader ) );
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        jdoOperationInstances.put( jdoOperation.getName(), jdoOperation );
        return jdoOperation;
    } //-- JdoOperation parseJdoOperation( XMLStreamReader, boolean )

    /**
     * Method parseJdoPermission.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoPermission
     */
    private JdoPermission parseJdoPermission( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        JdoPermission jdoPermission = new JdoPermission();
        java.util.Set parsed = new java.util.HashSet();
        if ( jdoPermissionInstances == null )
        {
            jdoPermissionInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            jdoPermissionInstances.put( v, jdoPermission );
        }
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "name", null, parsed ) )
            {
                jdoPermission.setName( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "description", null, parsed ) )
            {
                jdoPermission.setDescription( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "permanent", null, parsed ) )
            {
                jdoPermission.setPermanent( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "permanent", xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "operation", null, parsed ) )
            {
                String value = xmlStreamReader.getAttributeValue( null, "name" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( jdoOperationReferences == null )
                    {
                        jdoOperationReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) jdoOperationReferences.get( jdoPermission );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        jdoOperationReferences.put( jdoPermission, refs );
                    }
                    refs.put( "operation", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "resource", null, parsed ) )
            {
                String value = xmlStreamReader.getAttributeValue( null, "identifier" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( jdoResourceReferences == null )
                    {
                        jdoResourceReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) jdoResourceReferences.get( jdoPermission );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        jdoResourceReferences.put( jdoPermission, refs );
                    }
                    refs.put( "resource", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        jdoPermissionInstances.put( jdoPermission.getName(), jdoPermission );
        return jdoPermission;
    } //-- JdoPermission parseJdoPermission( XMLStreamReader, boolean )

    /**
     * Method parseJdoResource.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoResource
     */
    private JdoResource parseJdoResource( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        JdoResource jdoResource = new JdoResource();
        java.util.Set parsed = new java.util.HashSet();
        if ( jdoResourceInstances == null )
        {
            jdoResourceInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            jdoResourceInstances.put( v, jdoResource );
        }
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "identifier", null, parsed ) )
            {
                jdoResource.setIdentifier( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "pattern", null, parsed ) )
            {
                jdoResource.setPattern( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "pattern", xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "permanent", null, parsed ) )
            {
                jdoResource.setPermanent( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "permanent", xmlStreamReader ) );
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        jdoResourceInstances.put( jdoResource.getIdentifier(), jdoResource );
        return jdoResource;
    } //-- JdoResource parseJdoResource( XMLStreamReader, boolean )

    /**
     * Method parseJdoRole.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoRole
     */
    private JdoRole parseJdoRole( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        JdoRole jdoRole = new JdoRole();
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "name", null, parsed ) )
            {
                jdoRole.setName( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "description", null, parsed ) )
            {
                jdoRole.setDescription( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "assignable", null, parsed ) )
            {
                jdoRole.setAssignable( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "assignable", xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "permanent", null, parsed ) )
            {
                jdoRole.setPermanent( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "permanent", xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "childRoleNames", null, parsed ) )
            {
                java.util.List childRoleNames = new java.util.ArrayList/*<String>*/();
                jdoRole.setChildRoleNames( childRoleNames );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "childRoleName".equals( xmlStreamReader.getLocalName() ) )
                    {
                        childRoleNames.add( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()" ) ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "permissions", null, parsed ) )
            {
                java.util.List permissions = new java.util.ArrayList/*<JdoPermission>*/();
                jdoRole.setPermissions( permissions );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "permission".equals( xmlStreamReader.getLocalName() ) )
                    {
                        String value = xmlStreamReader.getAttributeValue( null, "name" );
                        if ( value != null )
                        {
                            // This is a reference to an element elsewhere in the model
                            if ( jdoPermissionReferences == null )
                            {
                                jdoPermissionReferences = new java.util.HashMap();
                            }
                            java.util.Map refs = (java.util.Map) jdoPermissionReferences.get( jdoRole );
                            if ( refs == null )
                            {
                                refs = new java.util.HashMap();
                                jdoPermissionReferences.put( jdoRole, refs );
                            }
                            refs.put( "permissions." + permissions.size(), value );
                        }
                        jdoRole.addPermission( parseJdoPermission( xmlStreamReader, strict ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        return jdoRole;
    } //-- JdoRole parseJdoRole( XMLStreamReader, boolean )

    /**
     * Method parseJdoUserAssignment.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return JdoUserAssignment
     */
    private JdoUserAssignment parseJdoUserAssignment( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        JdoUserAssignment jdoUserAssignment = new JdoUserAssignment();
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "principal", null, parsed ) )
            {
                jdoUserAssignment.setPrincipal( getTrimmedValue( xmlStreamReader.getElementText() ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "timestamp", null, parsed ) )
            {
                String dateFormat = "long";
                jdoUserAssignment.setTimestamp( getDateValue( getTrimmedValue( xmlStreamReader.getElementText() ), "timestamp", dateFormat, xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "permanent", null, parsed ) )
            {
                jdoUserAssignment.setPermanent( getBooleanValue( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "false" ) ), "permanent", xmlStreamReader ) );
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "roleNames", null, parsed ) )
            {
                java.util.List roleNames = new java.util.ArrayList/*<String>*/();
                jdoUserAssignment.setRoleNames( roleNames );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "roleName".equals( xmlStreamReader.getLocalName() ) )
                    {
                        roleNames.add( getTrimmedValue( getDefaultValue( xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()" ) ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        return jdoUserAssignment;
    } //-- JdoUserAssignment parseJdoUserAssignment( XMLStreamReader, boolean )

    /**
     * Method parseRbacDatabase.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    private RbacDatabase parseRbacDatabase( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        RbacDatabase rbacDatabase = new RbacDatabase();
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? xmlStreamReader.nextTag() : nextTag( xmlStreamReader ) ) == XMLStreamConstants.START_ELEMENT )
        {
            if ( checkFieldWithDuplicate( xmlStreamReader, "roles", null, parsed ) )
            {
                java.util.List roles = new java.util.ArrayList/*<JdoRole>*/();
                rbacDatabase.setRoles( roles );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "role".equals( xmlStreamReader.getLocalName() ) )
                    {
                        rbacDatabase.addRole( parseJdoRole( xmlStreamReader, strict ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "permissions", null, parsed ) )
            {
                java.util.List permissions = new java.util.ArrayList/*<JdoPermission>*/();
                rbacDatabase.setPermissions( permissions );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "permission".equals( xmlStreamReader.getLocalName() ) )
                    {
                        rbacDatabase.addPermission( parseJdoPermission( xmlStreamReader, strict ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "operations", null, parsed ) )
            {
                java.util.List operations = new java.util.ArrayList/*<JdoOperation>*/();
                rbacDatabase.setOperations( operations );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "operation".equals( xmlStreamReader.getLocalName() ) )
                    {
                        rbacDatabase.addOperation( parseJdoOperation( xmlStreamReader, strict ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "resources", null, parsed ) )
            {
                java.util.List resources = new java.util.ArrayList/*<JdoResource>*/();
                rbacDatabase.setResources( resources );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "resource".equals( xmlStreamReader.getLocalName() ) )
                    {
                        rbacDatabase.addResource( parseJdoResource( xmlStreamReader, strict ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( xmlStreamReader, "userAssignments", null, parsed ) )
            {
                java.util.List userAssignments = new java.util.ArrayList/*<JdoUserAssignment>*/();
                rbacDatabase.setUserAssignments( userAssignments );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( "userAssignment".equals( xmlStreamReader.getLocalName() ) )
                    {
                        rbacDatabase.addUserAssignment( parseJdoUserAssignment( xmlStreamReader, strict ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                checkUnknownElement( xmlStreamReader, strict );
            }
        }
        return rbacDatabase;
    } //-- RbacDatabase parseRbacDatabase( XMLStreamReader, boolean )

    /**
     * Method read.
     * 
     * @param xmlStreamReader
     * @param strict
     * @throws IOException
     * @throws XMLStreamException
     * @return RbacDatabase
     */
    private RbacDatabase read( XMLStreamReader xmlStreamReader, boolean strict )
        throws IOException, XMLStreamException
    {
        int eventType = xmlStreamReader.getEventType();
        String encoding = null;
        while ( eventType != XMLStreamConstants.END_DOCUMENT )
        {
            if ( eventType == XMLStreamConstants.START_DOCUMENT )
            {
                encoding = xmlStreamReader.getCharacterEncodingScheme();
            }
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                if ( strict && ! "rbacDatabase".equals( xmlStreamReader.getLocalName() ) )
                {
                    throw new XMLStreamException( "Expected root element 'rbacDatabase' but found '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation(), null );
                }
                RbacDatabase rbacDatabase = parseRbacDatabase( xmlStreamReader, strict );
                rbacDatabase.setModelEncoding( encoding );
                resolveReferences( rbacDatabase );
                return rbacDatabase;
            }
            eventType = xmlStreamReader.next();
        }
        throw new XMLStreamException( "Expected root element 'rbacDatabase' but found no element at all: invalid XML document", xmlStreamReader.getLocation(), null );
    } //-- RbacDatabase read( XMLStreamReader, boolean )

    /**
     * Method resolveReferences.
     * 
     * @param value
     */
    private void resolveReferences( RbacDatabase value )
    {
        java.util.Map refs;
        for ( java.util.Iterator i = value.getRoles().iterator(); i.hasNext(); )
        {
            resolveReferences( (JdoRole) i.next() );
        }
        for ( java.util.Iterator i = value.getPermissions().iterator(); i.hasNext(); )
        {
            resolveReferences( (JdoPermission) i.next() );
        }
    } //-- void resolveReferences( RbacDatabase )

    /**
     * Method resolveReferences.
     * 
     * @param value
     */
    private void resolveReferences( JdoRole value )
    {
        java.util.Map refs;
        if ( jdoPermissionReferences != null )
        {
            refs = (java.util.Map) jdoPermissionReferences.get( value );
            if ( refs != null )
            {
                for ( int i = 0; i < value.getPermissions().size(); i++ )
                {
                    String id = (String) refs.get( "permissions." + i );
                    JdoPermission ref = (JdoPermission) jdoPermissionInstances.get( id );
                    if ( ref != null )
                    {
                        value.getPermissions().set( i, ref );
                    }
                }
            }
        }
    } //-- void resolveReferences( JdoRole )

    /**
     * Method resolveReferences.
     * 
     * @param value
     */
    private void resolveReferences( JdoPermission value )
    {
        java.util.Map refs;
        if ( jdoOperationReferences != null )
        {
            refs = (java.util.Map) jdoOperationReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "operation" );
                JdoOperation ref = (JdoOperation) jdoOperationInstances.get( id );
                if ( ref != null && !ref.equals( value.getOperation() ) )
                {
                    value.setOperation( ref );
                }
            }
        }
        if ( jdoResourceReferences != null )
        {
            refs = (java.util.Map) jdoResourceReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "resource" );
                JdoResource ref = (JdoResource) jdoResourceInstances.get( id );
                if ( ref != null && !ref.equals( value.getResource() ) )
                {
                    value.setResource( ref );
                }
            }
        }
    } //-- void resolveReferences( JdoPermission )

}
