/*
 * $Id$
 */

package org.apache.archiva.redback.role.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ModelPermission implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field name
     */
    private String name;

    /**
     * Field description
     */
    private String description;

    /**
     * Field permanent
     */
    private boolean permanent = false;

    /**
     * Field operation
     */
    private String operation;

    /**
     * Field resource
     */
    private String resource;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof ModelPermission) )
        {
            return false;
        }
        
        ModelPermission that = (ModelPermission) other;
        boolean result = true;
        result = result && ( getId() == null ? that.getId() == null : getId().equals( that.getId() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get null
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get null
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get null
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get 
     *             the id of the operation for this permission
     *           
     */
    public String getOperation()
    {
        return this.operation;
    } //-- String getOperation() 

    /**
     * Get 
     *             the id of the resource for this permission, can
     * accept
     *             ${resource} for templates
     *           
     */
    public String getResource()
    {
        return this.resource;
    } //-- String getResource() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( id != null ? id.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Get 
     *             this permission should persist even if referring
     * roles are
     *             removed
     *           
     */
    public boolean isPermanent()
    {
        return this.permanent;
    } //-- boolean isPermanent() 

    /**
     * Set null
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set null
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set null
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *             the id of the operation for this permission
     *           
     * 
     * @param operation
     */
    public void setOperation(String operation)
    {
        this.operation = operation;
    } //-- void setOperation(String) 

    /**
     * Set 
     *             this permission should persist even if referring
     * roles are
     *             removed
     *           
     * 
     * @param permanent
     */
    public void setPermanent(boolean permanent)
    {
        this.permanent = permanent;
    } //-- void setPermanent(boolean) 

    /**
     * Set 
     *             the id of the resource for this permission, can
     * accept
     *             ${resource} for templates
     *           
     * 
     * @param resource
     */
    public void setResource(String resource)
    {
        this.resource = resource;
    } //-- void setResource(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "id = '" );
        buf.append( getId() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
