/*
 * $Id$
 */

package org.apache.archiva.redback.role.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ModelResource implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field name
     */
    private String name;

    /**
     * Field permanent
     */
    private boolean permanent = false;

    /**
     * Field pattern
     */
    private boolean pattern = false;

    /**
     * Field description
     */
    private String description;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof ModelResource) )
        {
            return false;
        }
        
        ModelResource that = (ModelResource) other;
        boolean result = true;
        result = result && ( getId() == null ? that.getId() == null : getId().equals( that.getId() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get null
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Get null
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get null
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( id != null ? id.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Get 
     *             this resource is a pattern, currently
     * unsupported
     *           
     */
    public boolean isPattern()
    {
        return this.pattern;
    } //-- boolean isPattern() 

    /**
     * Get 
     *             this resource should persist even if all
     * referring
     *             permissions are removed
     *           
     */
    public boolean isPermanent()
    {
        return this.permanent;
    } //-- boolean isPermanent() 

    /**
     * Set null
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set null
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set null
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *             this resource is a pattern, currently
     * unsupported
     *           
     * 
     * @param pattern
     */
    public void setPattern(boolean pattern)
    {
        this.pattern = pattern;
    } //-- void setPattern(boolean) 

    /**
     * Set 
     *             this resource should persist even if all
     * referring
     *             permissions are removed
     *           
     * 
     * @param permanent
     */
    public void setPermanent(boolean permanent)
    {
        this.permanent = permanent;
    } //-- void setPermanent(boolean) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "id = '" );
        buf.append( getId() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
